<?php

namespace App\Models;

use App\Services\DisputeTypeService;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class DisputeType extends Model
{
   use HasFactory, SoftDeletes;
   use DisputeTypeService;

   /**
    * The database table used by the model.
    *
    * @var string
    */
   protected $table = 'dispute_types';

   /**
    * Attributes that should be mass-assignable.
    *
    * @var array
    */
   protected $fillable = [
      'code',
      'designation',
   ];

   /**
    * The attributes excluded from the model's JSON form.
    *
    * @var array
    */
   protected $hidden = [];

   /**
    * The attributes that should be casted to native types.
    *
    * @var array
    */
   protected $casts = [];

   /**
    * The attributes that should be mutated to dates.
    *
    * @var array
    */
   protected $dates = ['created_at', 'updated_at', 'deleted_at'];

   /**
    * The "booting" method of the model.
    *
    * @return void
    */
   public static function boot(): void
   {
      parent::boot();

      static::retrieved(function (DisputeType $attribute) {
         $attribute->{'designation'} = __(
            $attribute->getOriginal('designation')
         );
      });
   }

   /** Attributes used outside the class to create modify the resource */

   /** Relations */
}
