<?php

namespace App\Models;

use App\Concerns\DisputeMessageNotificationConcern;
use App\Concerns\DisputeMessageBroadcastConcern;
use App\Services\DisputeMessageService;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class DisputeMessage extends Model
{
    use HasFactory, SoftDeletes;
    use DisputeMessageService;
    use DisputeMessageBroadcastConcern, DisputeMessageNotificationConcern;

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'dispute_messages';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'uuid',
        'message',
        'sent_at',

        'dispute_id',
        'emitter_participant_id',
        'respond_to_message_id',
    ];

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = [
        'id',
        'dispute_id',
        'emitter_participant_id',
        'respond_to_message_id',
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        "sent_at" => 'datetime',
    ];

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = ['created_at', 'updated_at', 'deleted_at', 'sent_at'];

    /**
     * The "booting" method of the model.
     *
     * @return void
     */
    public static function boot(): void
    {
        parent::boot();
    }

    /** Attributes used outside the class to create modify the resource */

    /** Relations */

    public function dispute(): \Illuminate\Database\Eloquent\Relations\BelongsTo
    {
        return $this->belongsTo(Dispute::class);
    }

    public function emitter(): \Illuminate\Database\Eloquent\Relations\BelongsTo
    {
        return $this->belongsTo(DisputeParticipant::class, 'emitter_participant_id');
    }
}
