<?php

namespace App\Models;

use App\Concerns\DisputeBroadcastConcern;
use App\Concerns\DisputeNotificationConcern;
use App\Services\DisputeService;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Dispute extends Model
{
   use HasFactory, SoftDeletes;
   use DisputeService;
   use DisputeBroadcastConcern, DisputeNotificationConcern;

   /**
    * The database table used by the model.
    *
    * @var string
    */
   protected $table = 'disputes';

   /**
    * Attributes that should be mass-assignable.
    *
    * @var array
    */
   protected $fillable = [
      'uuid',
      'name',
      'label_color',
      'status',

      'created_by_id',
      'transaction_id',
      'dispute_type_id',
   ];

   /**
    * The attributes excluded from the model's JSON form.
    *
    * @var array
    */
   protected $hidden = [
      'id',
      'created_by_id',
      'transaction_id',
      'dispute_type_id',
   ];

   /**
    * The attributes that should be casted to native types.
    *
    * @var array
    */
   protected $casts = [];

   /**
    * The attributes that should be mutated to dates.
    *
    * @var array
    */
   protected $dates = ['created_at', 'updated_at', 'deleted_at'];

   /**
    * The "booting" method of the model.
    *
    * @return void
    */
   public static function boot(): void
   {
      parent::boot();
   }

   /** Attributes used outside the class to create modify the resource */

   /** Relations */

   public function participants(): \Illuminate\Database\Eloquent\Relations\HasMany
   {
      return $this->hasMany(DisputeParticipant::class);
   }

   public function creator(): \Illuminate\Database\Eloquent\Relations\BelongsTo
   {
      return $this->belongsTo(User::class, 'created_by_id');
   }

   public function latestMessages(): \Illuminate\Database\Eloquent\Relations\HasMany
   {
      return $this->hasMany(DisputeMessage::class)->latest()->limit(30);
   }

   public function transaction(): \Illuminate\Database\Eloquent\Relations\BelongsTo
   {
      return $this->belongsTo(Transaction::class);
   }

   public function disputeType(): \Illuminate\Database\Eloquent\Relations\BelongsTo
   {
      return $this->belongsTo(DisputeType::class, 'dispute_type_id');
   }
}
