<?php

namespace App\Models;

use App\Services\CouponService;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Coupon extends Model
{
    use HasFactory;
    use SoftDeletes;
    use CouponService;

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'coupons';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'designation',
        'code',
        'description',
        'discount_type',
        'percentage_discount',
        'fixed_card_discount_amount',
        'product_discount_start_date',
        'expiring_date',
        'minimum_amount_to_spend',
        'maximum_amount_to_spend',

        'product_id',
        'business_id',
        'fixed_card_discount_currency_id',
        'minimum_amount_to_spend_currency_id',
        'maximum_amount_to_spend_currency_id',
    ];

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = [
        'product_id',
        'business_id',
        'fixed_card_discount_currency_id',
        'minimum_amount_to_spend_currency_id',
        'maximum_amount_to_spend_currency_id',
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'product_discount_start_date' => 'datetime',
        'expiring_date' => 'datetime',
    ];

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = ['created_at', 'updated_at', 'deleted_at', 'product_discount_start_date', 'expiring_date'];

    /**
     * The "booting" method of the model.
     *
     * @return void
     */
    public static function boot(): void
    {
        parent::boot();
    }

    /** Attributes used outside the class to create modify the resource */

    /** Relations */

    public function minimumAmountToSpendCurrency (): \Illuminate\Database\Eloquent\Relations\BelongsTo
    {
        return $this->belongsTo(Currency::class, 'minimum_amount_to_spend_currency_id');
    }

    public function maximumAmountToSpendCurrency (): \Illuminate\Database\Eloquent\Relations\BelongsTo
    {
        return $this->belongsTo(Currency::class, 'maximum_amount_to_spend_currency_id');
    }

    public function fixedCardDiscountCurrency (): \Illuminate\Database\Eloquent\Relations\BelongsTo
    {
        return $this->belongsTo(Currency::class, 'fixed_card_discount_currency_id');
    }

    public function product (): \Illuminate\Database\Eloquent\Relations\BelongsTo
    {
        return $this->belongsTo(Product::class);
    }

    public function productExclusion(): \Illuminate\Database\Eloquent\Relations\HasMany
    {
        return $this->hasMany(CouponProductExclusion::class);
    }
}
