<?php

namespace App\Models;

use App\Services\ContentRestrictionService;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ContentRestriction extends Model
{
    use HasFactory;
    use ContentRestrictionService;

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'content_restrictions';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'keyword',

        'user_id',
        'business_category_id',
        'business_sub_category_id',
        'business_sub_category_child_id',
    ];

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = [
        'user_id',
        'business_category_id',
        'business_sub_category_id',
        'business_sub_category_child_id',
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [];

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = ['created_at', 'updated_at', 'deleted_at'];

    /**
     * The "booting" method of the model.
     *
     * @return void
     */
    public static function boot()
    {
        parent::boot();
    }

    /** Attributes used outside the class to create modify the resource */

    /** Relations */

    public function businessCategory(): \Illuminate\Database\Eloquent\Relations\BelongsTo
    {
        return $this->belongsTo(BusinessCategory::class, 'business_category_id');
    }

    public function businessSubCategory(): \Illuminate\Database\Eloquent\Relations\BelongsTo
    {
        return $this->belongsTo(BusinessSubCategory::class, 'business_sub_category_id');
    }

    public function businessSubCategoryChild(): \Illuminate\Database\Eloquent\Relations\BelongsTo
    {
        return $this->belongsTo(BusinessSubCategoryChild::class, 'business_sub_category_child_id');
    }
}
