<?php

namespace App\Models;

use App\Services\CommunityMembershipRequestService;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CommunityMembershipRequest extends Model
{
   use HasFactory;
   use SoftDeletes;
   use CommunityMembershipRequestService;

   /**
    * The database table used by the model.
    *
    * @var string
    */
   protected $table = 'community_membership_requests';

   /**
    * Attributes that should be mass-assignable.
    *
    * @var array
    */
   protected $fillable = [
      'status',

      'user_id',
      'community_id',
   ];

   /**
    * The attributes excluded from the model's JSON form.
    *
    * @var array
    */
   protected $hidden = [
      'user_id',
      'community_id',
   ];

   /**
    * The attributes that should be casted to native types.
    *
    * @var array
    */
   protected $casts = [];

   /**
    * The attributes that should be mutated to dates.
    *
    * @var array
    */
   protected $dates = ['created_at', 'updated_at', 'deleted_at'];


   /** Relations */
   public function community(): \Illuminate\Database\Eloquent\Relations\BelongsTo
   {
      return $this->belongsTo(Community::class);
   }

   public function user(): \Illuminate\Database\Eloquent\Relations\BelongsTo
   {
      return $this->belongsTo(User::class);
   }
}
