<?php

namespace App\Models;

use App\Services\BusinessSubCategoryChildService;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class BusinessSubCategoryChild extends Model
{
    use HasFactory, SoftDeletes;
    use BusinessSubCategoryChildService;

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'business_sub_category_child';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'designation',
        'code',

        'parent_id',
        'business_sub_category_id'
    ];

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = [
        'parent_id',
        'business_sub_category_id',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [];

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = ['created_at', 'updated_at', 'deleted_at'];

    /**
     * The "booting" method of the model.
     *
     * @return void
     */
    public static function boot(): void
    {
        parent::boot();

        static::retrieved(function (BusinessSubCategoryChild $businessSubCategoryChild) {
            $businessSubCategoryChild->{'designation'} = __(
                $businessSubCategoryChild->getOriginal('designation')
            );
        });
    }

    // Relations

    public function businessSubCategoriesChild(): \Illuminate\Database\Eloquent\Relations\HasMany
    {
        return $this->hasMany(BusinessSubCategoryChild::class, 'parent_id', 'id');
    }
}
