<?php

namespace App\Models;

use App\Services\AttributeSiUnitService;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AttributeSiUnit extends Model
{
    use HasFactory, SoftDeletes;
    use AttributeSiUnitService;

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'attribute_si_units';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'si_unit',
        'si_unit_designation',

        'attribute_id',
    ];

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = [
        'attribute_id',
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [];

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = ['created_at', 'updated_at', 'deleted_at'];

    /**
     * The "booting" method of the model.
     *
     * @return void
     */
    public static function boot(): void
    {
        parent::boot();
    }

    /** Attributes used outside the class to create modify the resource */

    /** Relations */
}
