<?php

namespace App\Models;

use App\Services\AttributeService;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Attribute extends Model
{
    use HasFactory, SoftDeletes;
    use AttributeService;

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'attributes';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'designation',
        'type',
        'can_take_value',

        'business_id',
    ];

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = [
        'business_id',
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [];

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = ['created_at', 'updated_at', 'deleted_at'];

    /**
     * The "booting" method of the model.
     *
     * @return void
     */
    public static function boot(): void
    {
        parent::boot();

        static::retrieved(function (Attribute $attribute) {
            $attribute->{'designation'} = __(
                $attribute->getOriginal('designation')
            );
        });
    }

    /** Attributes used outside the class to create modify the resource */

    /**
     * Convert to custom json
     *
     * @param $data
     * @return array
     */
    public static function toCustomJson($data): array
    {
        if(is_array($data)) {
            return array(
                "id" => $data['id'],
                "designation" =>  $data['designation'],
                "can_take_value" =>  $data['can_take_value'],
                "type" =>  $data['type'],
                "attribute_values" =>  AttributeValue::getValuesForAttribute($data['id']),
            );
        }

        return array(
            "id" => $data->{'id'},
            "designation" =>  $data->{'designation'},
            "can_take_value" =>  $data->{'can_take_value'},
            "type" =>  $data->{'type'},
            "attribute_values" => AttributeValue::getValuesForAttribute($data->{'id'}),
        );
    }

    /** Relations */
}
