<?php

namespace App\Libs\Utility;

use Illuminate\Http\UploadedFile;
use Illuminate\Support\Str;

class Utility
{
    static function isPdf(UploadedFile $uploadedFile): bool
    {
        return Str::contains($uploadedFile->getMimeType(), "application/pdf");
    }

    static function isImage(UploadedFile $uploadedFile): bool
    {
        return Str::startsWith($uploadedFile->getMimeType(), "image");
    }

    static function isAudio(UploadedFile $uploadedFile): bool
    {
        return Str::startsWith($uploadedFile->getMimeType(), "audio");
    }

    static function isVideo(UploadedFile $uploadedFile): bool
    {
        return Str::startsWith($uploadedFile->getMimeType(), "video");
    }
}
