<?php

namespace App\Libs\Sms;

use Patrickmaken\AvlyText\Client as AVTClient;
use Exception;
use GuzzleHttp\Exception\GuzzleException;

class AvlyProvider extends SmsProvider
{
    /**
     * Default constructor.
     *
     * @param array $phoneNumbers
     * @param string $message
     */
    public function __construct(
        protected array $phoneNumbers,
        protected string $message,
    ) {
        parent::__construct($phoneNumbers, $message);
    }

    /**
     * Send message
     *
     * @return bool
     */
    public function send(): bool
    {
        $phoneNumber = $this->phoneNumbers[0];

        try {
            $response = AVTClient::sendSMS(
                $phoneNumber,
                $this->message,
                config('torryme.api_tokens.avly_provider.sender_id'),
                config('torryme.api_tokens.avly_provider.api_key'),
            );

            return isset($response['status']) && mb_strtolower($response['status']) === 'success';
        } catch (Exception|GuzzleException $exception) {
            log_debug($exception, "AvlyProvider::send -- AVLY SMS:: Unable to send sms to " . $phoneNumber);
        }

        return false;
    }
}
