<?php

namespace App\Http\Controllers\Api\Platform;

use App\Exceptions\UploadFileException;
use App\Exceptions\UserNameAlreadyExistException;
use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\UserVerification;
use App\RequestRules\Api\UserVerificationRules;
use Exception;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\Routing\ResponseFactory;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class UserVerificationController extends Controller
{
    /**
     * Request validation
     *
     * @param Request $request
     * @return Application|ResponseFactory|Response
     */
    public function requestVerification(Request $request): Response|Application|ResponseFactory
    {
        $request->validate(UserVerificationRules::requestVerification());
        $data = $request->all();

        try {
            // TODO Check user_name is unique for current user and is not used by other users

            $result = UserVerification::requestVerification($data);

            return api_response(100, "Okay", $result);
        } catch (Exception $exception) {
            log_debug(exception: $exception, prefix: 'UserVerificationController::requestVerification');

            if ($exception instanceof UploadFileException || $exception instanceof UserNameAlreadyExistException) {
                return api_response(120, $exception->getMessage());
            }
        }

        return api_response(120, __("errors.unknown_error"));
    }

    /**
     * Check verification status
     *
     * @return Application|ResponseFactory|Response
     */
    public function checkStatus(): Response|Application|ResponseFactory
    {
        /** @var User $user */
        $user = auth()->user();

        $result = $user->userVerificationStatus();

        if($user->noRequestSubmitted()) {
            return api_response(130, __("messages.no_verification_request_submitted"));
        }

        if ($result == null) {
            return api_response(120, __("errors.unknown_error"));
        }

        return api_response(100, "Ok", $result);
    }

}
