<?php

namespace App\Http\Controllers\Api\Platform;

use App\Enums\LogLevelEnum;
use App\Http\Controllers\Api\Auth\AuthenticateController;
use App\Models\User;
use App\Models\UserDevice;
use App\RequestRules\Api\UserDeviceRules;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\Routing\ResponseFactory;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Arr;
use Illuminate\Validation\ValidationException;

class UserDeviceController extends AuthenticateController
{
    /**
     * Send otp code request
     *
     * @param Request $request
     * @return Response|Application|ResponseFactory
     * @throws ValidationException
     */
    public function replaceDevice(Request $request): Response|Application|ResponseFactory
    {
        $this->validate($request, UserDeviceRules::replaceDeviceRules());

        /** @var User $user */
        $user = auth()->user();

        try {
            $user->{'userDevice'}->updateService(array_merge(
                Arr::only($request->all(), UserDevice::updateAttributes()),
                ['native_device_id' => $request->{'native_device_id'}]
            ));

            return $this->respondWithToken(
                $user->refresh(),
                data: ['user' => self::responseWithUser($user)]
            );
        } catch (\Exception $exception) {
            log_debug(exception: $exception, prefix: 'UserDeviceController::replaceDevice');
        }

        return api_response(101, __('errors.error'));
    }
}
