<?php

namespace App\Http\Controllers\Api\Platform;

use App\Http\Controllers\Controller;
use App\Models\Series;
use App\RequestRules\Api\SeriesRequestRules;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\Routing\ResponseFactory;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Mockery\Exception;

class SeriesController extends Controller
{
    /**
     * Get series seasons
     *
     * @param Request $request
     * @return Application|ResponseFactory|Response
     */
    public function seasons(Request $request): Response|Application|ResponseFactory
    {
        try {
            /** @var Series $series */
            $series = Series::findById($request->{"seriesId"});

            if($series === null) {
                return api_response(120, __('errors.unknown_series'));
            }

            $seasonArray = array();
            foreach ($series->{"seasons"} as $season) {
                $seasonArray[] = $season;
            }

            return api_response(100, "Okay", $seasonArray);
        } catch (Exception $exception) {
            log_debug($exception, "SeriesController::seasons");
        }

        return api_response(120, __("errors.unknown_error"));
    }



}
