<?php

namespace App\Http\Controllers\Api\Platform;

use App\Http\Controllers\Controller;
use App\Models\ReportedProblem;
use App\RequestRules\Api\ReportedProblemRequestRules;
use Exception;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\Routing\ResponseFactory;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class ReportedProblemController extends Controller
{
    /**
     * Create report problem
     *
     * @param Request $request
     * @return Application|ResponseFactory|Response
     */
    public function add(Request $request): Response|Application|ResponseFactory
    {
        $request->validate(ReportedProblemRequestRules::create());

        try {
            $result = ReportedProblem::createReportProblem(
                $request->{"problem_description"}
            );

            return api_response(100, 'Ok', $result);
        } catch (Exception $exception) {
            log_debug(exception: $exception, prefix: 'ReportedProblemController::add');
        }

        return api_response(101, __('errors.unknown_error'));
    }
}
