<?php

namespace App\Http\Controllers\Api\Platform;

use App\Http\Controllers\Controller;
use App\Models\FavouriteCategory;
use App\RequestRules\Api\FavouriteCategoryRequestRules;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\Routing\ResponseFactory;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class FavoriteCategoryController extends Controller
{
    /**
     * Create favourite category
     *
     * @param Request $request
     * @return Application|ResponseFactory|Response
     */
    public function create(Request $request): Response|Application|ResponseFactory
    {
        $request->validate(FavouriteCategoryRequestRules::create());

        $favouriteCategory = FavouriteCategory::create($request->{"designation"});

        if ($favouriteCategory == null) {
            return api_response(120, __('errors.unknown_error'));
        }

        return api_response(100, "Okay", $favouriteCategory->commonSerialization());
    }

    /**
     * Get user's categories
     *
     * @param Request $request
     * @return Response|Application|ResponseFactory
     */
    public function getCategories(Request $request): Response|Application|ResponseFactory
    {
        $favouriteCategories = FavouriteCategory::getCategories(
            postId: $request->{'post'},
        );

        return api_response(100, "Okay", $favouriteCategories);
    }

    /**
     * Update favourite category
     *
     * @param Request $request
     * @return Application|ResponseFactory|Response
     */
    public function updateCategory(Request $request): Response|Application|ResponseFactory
    {
        $request->validate(FavouriteCategoryRequestRules::update());
        $data = $request->all();

        /** @var FavouriteCategory $categoryToUpdate */
        $categoryToUpdate = FavouriteCategory::findById($data["favourite_category_id"]);
        $updatedCategory = $categoryToUpdate->updateCategory($data["designation"]);

        return api_response(100, "Okay", $updatedCategory);
    }

    /**
     * Delete category
     *
     * @param Request $request
     * @return Application|ResponseFactory|Response
     */
    public function deleteCategory(Request $request): Response|Application|ResponseFactory
    {
        $request->validate(FavouriteCategoryRequestRules::delete());

        /** @var FavouriteCategory $categoryToUpdate */
        $categoryToUpdate = FavouriteCategory::findById($request->get("favourite_category_id"));
        $categoryToUpdate->deleteCategory();

        return api_response(100, "Okay");
    }
}
