<?php

namespace App\Http\Controllers\Api\Platform;

use App\Exceptions\WalletBlockedException;
use App\Exceptions\WalletRemainingPinAttemptsException;
use App\Http\Controllers\Controller;
use App\Models\ExternalAccount;
use App\RequestRules\Api\ExternalAccountRules;
use Exception;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\Routing\ResponseFactory;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class ExternalAccountController extends Controller
{
    /**
     * Configure account
     *
     * @param Request $request
     * @return Application|ResponseFactory|Response
     */
    public function configureAccount(Request $request): Response|Application|ResponseFactory
    {
        $request->validate(ExternalAccountRules::configureAccount());

        $data = $request->all();

        try {
            $result = ExternalAccount::configureAccount($data);

            return api_response(100, "Okay", $result);
        } catch (Exception $exception) {
            log_debug(exception: $exception, prefix: 'ExternalAccountController::configureAccount');
            $walletException = self::returnWalletException($exception);

            if ($walletException != null) {
                return $walletException;
            }
        }

        return api_response(120, __("errors.unknown_error"));
    }

    /**
     * Edit account
     *
     * @param Request $request
     * @return Application|ResponseFactory|Response
     */
    public function editAccount(Request $request): Response|Application|ResponseFactory
    {
        $request->validate(ExternalAccountRules::editAccount());

        $data = $request->all();

        try {
            $result = ExternalAccount::editAccount($data);

            return api_response(100, "Okay", $result);
        }catch (Exception $exception) {
            log_debug(exception: $exception, prefix: 'ExternalAccountController::editAccount');
            $walletException = self::returnWalletException($exception);

            if ($walletException != null) {
                return $walletException;
            }
        }

        return api_response(120, __("errors.unknown_error"));
    }

    /**
     * Get user accounts
     *
     * @param Request $request
     * @return Application|ResponseFactory|Response
     */
    public function userAccounts(Request $request): Response|Application|ResponseFactory
    {
        $request->validate(ExternalAccountRules::userAccounts());

        $result = ExternalAccount::userAccounts($request->get("operation_direction"));

        if($result !== null) {
            return api_response(100, "Okay", $result);
        }

        return api_response(120, __("errors.unknown_error"));
    }


    // Controller utilities

    /**
     * Return exception
     *
     * @param Exception $exception
     * @return Response|Application|ResponseFactory|null
     */
    protected static function returnWalletException(Exception $exception): Response|Application|ResponseFactory|null
    {
        if ($exception instanceof WalletBlockedException || $exception instanceof WalletRemainingPinAttemptsException) {
            return api_response(120, $exception->getMessage());
        }

        return null;
    }
}
