<?php

namespace App\Http\Controllers\Api\Platform;

use App\Http\Controllers\Controller;
use App\Models\DisputeMessage;
use App\RequestRules\Api\DisputeRequestRules;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\Routing\ResponseFactory;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class DisputeMessageController extends Controller
{
   /**
    * New message
    *
    * @param Request $request
    * @return Response|Application|ResponseFactory
    */
   public function newMessage(Request $request): Response|Application|ResponseFactory
   {
      // Validation ...
      $request->validate(DisputeRequestRules::newMessageRules());

      /** @var ?DisputeMessage $message */
      $result = DisputeMessage::newMessage($request->all());

      if ($result !== null) {
         return api_response(100, "Okay", $result);
      }

      return api_response(101, __("errors.unknown_error"));
   }
}
