<?php

namespace App\Http\Controllers\Api\Platform;

use App\Http\Controllers\Controller;
use App\Models\Chat;
use App\Models\User;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\Routing\ResponseFactory;
use Illuminate\Http\Response;

class ChatController extends Controller
{
    /**
     * Chat history
     *
     * @return Response|Application|ResponseFactory
     */
    public function history(): Response|Application|ResponseFactory
    {
        /** @var User $user */
        $user = auth()->user();

        try {
            $message = Chat::history($user);

            return api_response(100, "Okay", $message);
        } catch (\Exception $exception) {
            log_debug($exception, 'ChaController::history');
        }

        return api_response(101, __("errors.unknown_error"));
    }
}
