<?php

namespace App\Http\Controllers\Api\Platform;

use App\Http\Controllers\Controller;
use App\Models\BusinessCategory;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\Routing\ResponseFactory;
use Illuminate\Http\Response;

class BusinessCategoryController extends Controller
{
    /**
     * Get all business categories
     *
     * @return Application|ResponseFactory|Response
     */
    public function businessCategories(): Response|Application|ResponseFactory
    {
        try {
            $businessCategories = BusinessCategory::allBusinessCategories();

            return api_response(100, 'Ok', $businessCategories);
        } catch (\Exception $exception) {
            log_debug(exception: $exception, prefix: 'BusinessCategoryController::businessCategories');
        }

        return api_response(101, __('errors.unknown_error'));
    }
}
