<?php

namespace App\Http\Controllers\Api\Platform;

use App\Http\Controllers\Controller;
use App\Models\AccountNotificationSetting;
use App\Models\User;
use App\RequestRules\Api\AccountNotificationSettingRequestRules;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\Routing\ResponseFactory;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class AccountNotificationSettingsController extends Controller
{

    /**
     * Get account notification settings
     *
     * @return Application|ResponseFactory|Response
     */
    public function index(): Response|Application|ResponseFactory
    {
        try {
            /** @var User $user */
            $user = auth()->user();

            return api_response(100, 'Ok', $user->{"accountNotificationSetting"});
        } catch (\Exception $exception) {
            log_debug(exception: $exception, prefix: 'AccountNotificationSettingsController::index');
        }

        return api_response(101, __('errors.unknown_error'));
    }

    /**
     * Edit account notification settings
     *
     * @param Request $request
     * @return Application|ResponseFactory|Response
     */
    public function edit(Request $request): Response|Application|ResponseFactory
    {
        $request->validate(AccountNotificationSettingRequestRules::editAccountNotification());
        $data = $request->all();

        try {
            /** @var User $user */
            $user = auth()->user();

            /** @var AccountNotificationSetting $accountNotificationSetting */
            $accountNotificationSetting = $user->{"accountNotificationSetting"};

            $results = $accountNotificationSetting->updateNotificationSettings($data);
            return api_response(100, 'Ok', $results);
        } catch (\Exception $exception) {
            log_debug(exception: $exception, prefix: 'AccountPrivacySettingsController::edit');
        }

        return api_response(101, __('errors.unknown_error'));
    }
}
