<?php

namespace App\Events;

use App\Enums\ChannelEnum;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class SendDisputeMessageEvent implements ShouldBroadcast
{
   use Dispatchable, InteractsWithSockets, SerializesModels;

   /**
    * NewMessageSent constructor.
    *
    * @param array $message
    * @param string $disputeUuid
    */
   public function __construct(private readonly array $message)
   {
   }

   /**
    * Get the channels the event should broadcast on.
    *
    * @return PrivateChannel
    */
   public function broadcastOn(): PrivateChannel
   {
      // Build broadcast channel ...
      $channel = sprintf(
         ChannelEnum::ioDisputeChannel->{'value'},
         $this->message['dispute_uuid'],
      );
      log_debug(null, "Try to broadcast for sending dispute message into " . $channel);

      return new PrivateChannel($channel);
   }

   /**
    * Broadcast's event name
    *
    * @return string
    */
   public function broadcastAs(): string
   {
      return ChannelEnum::sendDisputeMessageEvent->{'value'};
   }

   /**
    * Data sending back to client
    *
    * @return array
    */
   public function broadcastWith(): array
   {
      return $this->message;
   }

   /**
    * The name of the queue on which to place the broadcasting job.
    */
   public function broadcastQueue(): string
   {
      return 'dispute';
   }
}
