<?php

namespace App\Enums;

enum ChannelEnum: string
{
   // Chat
   case ioChatChannel = "[chat:io]/%s";
   case sendMessageEvent = "chat.send.message";
   case deliveryMessageEvent = "chat.delivery.message";
   case readyMessageEvent = "chat.read.message";

   // Dispute
   case ioDisputeChannel = "[dispute:io]/%s";
   case disputeInvitationEvent = "dispute.invitation";
   case sendDisputeMessageEvent = "dispute.send.message";

   // Community
   case memberShipStatus = "community.membership.status";
}
