<?php

namespace App\Concerns;

use App\Models\User;

trait DisputeNotificationConcern
{
   /**
    * Notify dispute participants for invitation
    *
    * @return void
    */
   public function sendDisputeInvitationNotification(): void
   {
      $dispute = $this;
      $participants = $dispute->{'participants'};

      foreach ($participants as $participant) {
         /** @var User $participantUser */
         $participantUser = $participant->{'user'};

         if (auth()->id() !== $participantUser->{'id'}) {
            $participantUser->notifyForDisputeInvitation($dispute);
         }
      }
   }
}
