<?php

namespace App\Concerns;

use App\Models\User;

trait DisputeMessageNotificationConcern
{
   /**
    * Send notification for incoming message
    *
    * @return void
    */
   public function sendNewMessageNotification(): void
   {
      /** @var User $user */
      $user = auth()->user();

      $message = $this;
      $participants = $message->{'dispute'}->{'participants'};

      foreach ($participants as $participant) {
         /** @var User $participantUser */
         $participantUser = $participant->{'user'};

         if ($user->{'id'} !== $participantUser->{'id'}) {
            $participantUser->notifyForNewDisputeMessage(
               $message->serializeForChannel(),
            );
         }
      }
   }
}
