/*
 * @package    mod_videotime
 * @copyright  2021 bdecent gmbh <https://bdecent.de>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("mod_videotime/videotime",["jquery","mod_videotime/player","core/ajax","core/config","core/log","core/templates","core/notification"],(function($,Vimeo,Ajax,Config,Log,Templates,Notification){let VideoTime=function(elementId,cmId,hasPro,interval,instance){this.elementId=elementId,this.cmId=cmId,this.hasPro=hasPro,this.interval=interval,this.player=null,this.resumeTime=null,this.session=null,this.instance=instance,this.played=!1,this.playing=!1,this.time=0,this.percent=0,this.currentTime=0,this.playbackRate=1,this.plugins=[],hasPro&&$("body").hasClass("path-course-view")&&!$("body").hasClass("vtinit")&&($("body").addClass("vtinit"),$(document).on("focus","body",this.initializeNewInstances.bind(this))),this.modulecount=$("body .activity.videotime").length};return VideoTime.prototype.getCmId=function(){return this.cmId},VideoTime.prototype.registerPlugin=function(plugin){this.plugins.push(plugin)},VideoTime.prototype.initialize=function(){let instance=this.instance;Log.debug("Initializing Video Time "+this.elementId),Log.debug("Initializing Vimeo player with options:"),Log.debug(instance),this.player=new Vimeo(this.elementId,{autopause:Number(instance.autopause),autoplay:Number(instance.autoplay),background:Number(instance.background),byline:Number(instance.byline),color:instance.color,controls:Number(instance.controls),dnt:Number(instance.dnt),height:instance.height,loop:Number(instance.option_loop),maxheight:instance.maxheight,maxwidth:instance.maxwidth,muted:Number(instance.muted),portrait:instance.portrait,pip:Number(instance.pip),playsinline:instance.playsinline,responsive:Number(instance.responsive),speed:instance.speed,title:Number(instance.title),transparent:Number(instance.transparent),url:instance.vimeo_url,width:instance.width});let url=new URL(window.location.href),q=url.searchParams.get("q"),starttime=(url.searchParams.get("time")||"").match(/^([0-9]+:){0,2}([0-9]+)(\.[0-9]+)$/);starttime?this.setStartTime(starttime[0]).then((function(){return q&&window.find&&window.find(q),!0})).catch(Notification.exception):q&&window.find&&window.find(q),this.addListeners();for(let i=0;i<this.plugins.length;i++){this.plugins[i].initialize(this,instance)}return!0},VideoTime.prototype.getPlayer=function(){return this.player},VideoTime.prototype.addListeners=function(){this.player?($($("#"+this.elementId).closest(".videotimetabs")).each(function(i,tabs){$(tabs).find('[data-action="cue"]').each(function(index,anchor){let starttime=anchor.getAttribute("data-start"),time=starttime.match(/((([0-9]+):)?(([0-9]+):))?([0-9]+(\.[0-9]+))/);time&&this.player.addCuePoint(3600*Number(time[3]||0)+60*Number(time[5]||0)+Number(time[6]),{starttime:starttime}).catch(Notification.exeception)}.bind(this)),this.player.on("cuepoint",(function(event){event.data.starttime&&($(tabs).find(".videotime-highlight").removeClass("videotime-highlight"),$(tabs).find('[data-action="cue"][data-start="'+event.data.starttime+'"]').closest(".row").addClass("videotime-highlight"),$(".videotime-highlight").each((function(){this.offsetTop&&this.parentNode.scrollTo({top:this.offsetTop-50,left:0,behavior:"smooth"})})))}))}.bind(this)),this.player.on("play",(()=>(this.hasPro&&this.startWatchInterval(),this.view(),!0))),this.hasPro&&(this.player.on("loaded",(()=>!this.instance.resume_playback||!this.instance.resume_time||this.instance.resume_time<=0||this.getDuration().then((duration=>{let resumeTime=this.instance.resume_time;return resumeTime+1>=Math.floor(duration)&&(Log.debug("VIDEO_TIME video finished, resuming at start of video."),resumeTime=0),Log.debug("VIDEO_TIME duration is "+duration),Log.debug("VIDEO_TIME resuming at "+resumeTime),this.setCurrentPosition(resumeTime),!0})).fail(Notification.exception))),this.player.on("play",function(){this.playing=!0,Log.debug("VIDEO_TIME play")}.bind(this)),this.player.on("playing",function(){this.playing=!0,Log.debug("VIDEO_TIME playing")}.bind(this)),this.player.on("pause",function(){this.playing=!1,Log.debug("VIDEO_TIME pause")}.bind(this)),this.player.on("stalled",function(){this.playing=!1,Log.debug("VIDEO_TIME stalled")}.bind(this)),this.player.on("suspend",function(){this.playing=!1,Log.debug("VIDEO_TIME suspend")}.bind(this)),this.player.on("abort",function(){this.playing=!1,Log.debug("VIDEO_TIME abort")}.bind(this)),this.player.getPlaybackRate().then(function(playbackRate){this.playbackRate=playbackRate}.bind(this)).catch(Notification.exception),this.player.on("playbackratechange",function(event){this.playbackRate=event.playbackRate}.bind(this)),this.player.on("timeupdate",function(event){this.percent=event.percent,this.currentTime=event.seconds,event.seconds===event.duration&&this.plugins.forEach((plugin=>{"function"==typeof plugin.setCurrentTime&&plugin.getSessions().then((session=>(plugin.setCurrentTime(session.id,event.seconds),session))).catch(Notification.exception)}))}.bind(this)),this.player.on("ended",this.handleEnd.bind(this)),this.player.on("pause",this.handlePause.bind(this)))):Log.debug("Player was not properly initialized for course module "+this.cmId)},VideoTime.prototype.handlePause=function(){this.plugins.forEach((plugin=>{"function"==typeof plugin.handlePause&&plugin.handlePause()}))},VideoTime.prototype.handleEnd=function(){this.playing=!1,Log.debug("VIDEO_TIME ended"),this.plugins.length>2?this.plugins.forEach((plugin=>{"function"==typeof plugin.handleEnd&&plugin.handleEnd()})):this.getSession().then(function(session){this.setSessionState(session.id,1).then((()=>this.setPercent(session.id,1))).then((()=>this.setCurrentTime(session.id,this.currentTime))).then((()=>this.getNextActivityButtonData(session.id).then((response=>{let data=JSON.parse(response.data);if(data.instance&&parseInt(data.instance.next_activity_auto)&&!data.is_restricted&&data.hasnextcm){let link=$('.aalink[href="'+data.nextcm_url+'"] img').first();$(".path-course-view").length&&link?link.click():window.location.href=data.nextcm_url}return Templates.render("videotime/next_activity_button",JSON.parse(response.data)).then((function(html){return $("#next-activity-button").html(html),!0}))})))).catch(Notification.exception)}.bind(this)).catch(Notification.exception)},VideoTime.prototype.startWatchInterval=function(){this.plugins.forEach((plugin=>{"function"==typeof plugin.startWatchInterval&&(this.watchInterval=!0,plugin.startWatchInterval())})),this.watchInterval||(this.watchInterval=setInterval(function(){this.playing&&(this.time+=this.playbackRate,this.getSession().then(function(session){return this.time/this.playbackRate%this.interval==0&&(Log.debug("VIDEO_TIME watch_time: "+this.time+". percent: "+this.percent),this.recordWatchTime(session.id,this.time),this.setPercent(session.id,this.percent),this.setCurrentTime(session.id,this.currentTime)),!0}.bind(this)).catch(Notification.exception))}.bind(this),1e3))},VideoTime.prototype.setSessionState=function(sessionId,state){if(this.instance.token){const url=new URL(Config.wwwroot+"/webservice/rest/server.php"),data=url.searchParams;return data.set("wstoken",this.instance.token),data.set("moodlewsrestformat","json"),data.set("wsfunction","videotimeplugin_pro_set_session_state"),data.set("state",state),data.set("session_id",sessionId),fetch(url).then((response=>(response.ok||Notification.exeption("Web service error"),response.json())))}return Ajax.call([{methodname:"videotimeplugin_pro_set_session_state",args:{session_id:sessionId,state:state},fail:Notification.exception}])[0]},VideoTime.prototype.setCurrentTime=function(sessionId,currentTime){if(this.instance.token){const url=new URL(Config.wwwroot+"/webservice/rest/server.php"),data=url.searchParams;return data.set("wstoken",this.instance.token),data.set("moodlewsrestformat","json"),data.set("wsfunction","videotimeplugin_pro_set_session_current_time"),data.set("current_time",currentTime),data.set("session_id",sessionId),fetch(url).then((response=>(response.ok||Notification.exeption("Web service error"),response.json())))}return Ajax.call([{methodname:"videotimeplugin_pro_set_session_current_time",args:{session_id:sessionId,current_time:currentTime},fail:Notification.exception}])[0]},VideoTime.prototype.setPercent=function(sessionId,percent){if(this.instance.token){const url=new URL(Config.wwwroot+"/webservice/rest/server.php"),data=url.searchParams;return data.set("wstoken",this.instance.token),data.set("moodlewsrestformat","json"),data.set("wsfunction","videotimeplugin_pro_set_percent"),data.set("percent",percent),data.set("session_id",sessionId),fetch(url).then((response=>(response.ok||Notification.exeption("Web service error"),response.json())))}return Ajax.call([{methodname:"videotimeplugin_pro_set_percent",args:{session_id:sessionId,percent:percent},fail:Notification.exception}])[0]},VideoTime.prototype.recordWatchTime=function(sessionId,time){if(this.instance.token){const url=new URL(Config.wwwroot+"/webservice/rest/server.php"),data=url.searchParams;return data.set("wstoken",this.instance.token),data.set("moodlewsrestformat","json"),data.set("wsfunction","videotimeplugin_pro_record_watch_time"),data.set("session_id",sessionId),data.set("time",time),fetch(url).then((response=>(response.ok||Notification.exeption("Web service error"),response.json())))}return Ajax.call([{methodname:"videotimeplugin_pro_record_watch_time",args:{session_id:sessionId,time:time},fail:Notification.exception}])[0]},VideoTime.prototype.getNextActivityButtonData=function(sessionId){return this.instance.token?Promise.resolve({data:"{}"}):Ajax.call([{methodname:"videotimeplugin_pro_get_next_activity_button_data",args:{session_id:sessionId}}])[0]},VideoTime.prototype.getInstance=function(){return this.instance?Promise.resolve(this.instance):Ajax.call([{methodname:"mod_videotime_get_videotime",args:{cmid:this.cmId},done:response=>(this.instance=response,this.instance),fail:Notification.exception}])[0]},VideoTime.prototype.getResumeTime=function(){return this.resumeTime?Promise.resolve(this.resumeTime):Ajax.call([{methodname:"videotimeplugin_pro_get_resume_time",args:{cmid:this.cmId},done:response=>(this.resumeTime=response.seconds,this.resumeTime),fail:Notification.exception}])[0]},VideoTime.prototype.getSession=function(){if(this.instance.token){if(!this.session){const url=new URL(Config.wwwroot+"/webservice/rest/server.php"),data=url.searchParams;data.set("wstoken",this.instance.token),data.set("moodlewsrestformat","json"),data.set("wsfunction","videotimeplugin_pro_get_new_session"),data.set("cmid",this.cmId),this.session=fetch(url).then((response=>(response.ok||Notification.exeption("Web service error"),response.json())))}return this.session}return this.session||(this.session=Ajax.call([{methodname:"videotimeplugin_pro_get_new_session",args:{cmid:this.cmId},fail:Notification.exception}])[0]),this.session},VideoTime.prototype.setStartTime=function(starttime){let time=starttime.match(/((([0-9]+):)?(([0-9]+):))?([0-9]+(\.[0-9]+))/);return time&&(this.resumeTime=3600*Number(time[3]||0)+60*Number(time[5]||0)+Number(time[6]),this.currentTime(this.resumeTime)),this.player.getCurrentTime()},VideoTime.prototype.view=function(){if(this.instance.token){const url=new URL(Config.wwwroot+"/webservice/rest/server.php"),data=url.searchParams;return data.set("wstoken",this.instance.token),data.set("moodlewsrestformat","json"),data.set("wsfunction","mod_videotime_view_videotime"),data.set("cmid",this.cmId),fetch(url).then((response=>(response.ok||Notification.exeption("Web service error"),response.json())))}return Ajax.call([{methodname:"mod_videotime_view_videotime",args:{cmid:this.cmId},fail:Notification.exception}])[0]},VideoTime.prototype.initializeNewInstances=function(){this.modulecount!=$("body .activity.videotime").length&&(this.modulecount=$("body .activity.videotime").length,$("body .activity.videotime").each(function(index,module){if(!$(module).find(".instancename").length&&$(module).find(".vimeo-embed").length&&!$(module).find(".vimeo-embed iframe").length){let instance={cmid:Number($(module).attr("id").replace("module-","")),haspro:!0,interval:this.interval,uniqueid:$(module).find(".vimeo-embed").first().attr("id").replace("vimeo-embed-","")};Templates.render("mod_videotime/videotime_instance",{instance:instance}).then((function(html,js){return Templates.runTemplateJS(js),!0})).fail(Notification.exception)}}.bind(this)))},VideoTime.prototype.getPlaybackRate=function(){return this.player.getPlaybackRate()},VideoTime.prototype.getDuration=function(){return this.player.getDuration()},VideoTime.prototype.setCurrentPosition=function(secs){return this.player.setCurrentTime(secs)},VideoTime.prototype.getCurrentPosition=function(){return this.player.getCurrentTime()},VideoTime}));

//# sourceMappingURL=videotime.min.js.map