define("mod_threesixo/questionnaire",["exports","core/notification","core/ajax","core/str","core/modal_factory","core/modal_events","core/toast"],(function(_exports,_notification,_ajax,_str,_modal_factory,_modal_events,_toast){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Questionnaire JS module.
   *
   * @module     mod_threesixo/questionnaire
   * @class      questionnaire
   * @copyright  2016 Jun Pataleta <jun@moodle.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.init=void 0,_notification=_interopRequireDefault(_notification),_ajax=_interopRequireDefault(_ajax),_modal_factory=_interopRequireDefault(_modal_factory),_modal_events=_interopRequireDefault(_modal_events);const selectors_commentItem='textarea[data-region="comment-item"]',selectors_questionnaireTable='[data-region="questionnaire"]',selectors_ratingOption="input[type=radio]",selectors_questionItem='[data-region="question-item"]',responses=[];_exports.init=()=>{registerEvents();const questionItems=document.querySelectorAll(selectors_questionItem);questionItems.forEach((option=>{responses[option.getAttribute("data-itemid")]=null}));const questionnaireTable=document.querySelector(selectors_questionnaireTable),fromUser=questionnaireTable.getAttribute("data-fromuserid"),toUser=questionnaireTable.getAttribute("data-touserid"),threesixtyId=questionnaireTable.getAttribute("data-threesixtyid");_ajax.default.call([{methodname:"mod_threesixo_get_responses",args:{threesixtyid:threesixtyId,fromuserid:fromUser,touserid:toUser}}])[0].then((result=>(result.responses.forEach((response=>{responses[response.item]=response.value;const responseItemId=parseInt(response.item);questionItems.forEach((questionItem=>{if(parseInt(questionItem.getAttribute("data-itemid"))===responseItemId){const options=questionItem.querySelectorAll(selectors_ratingOption);if(options.length)options.forEach((option=>{option.value===response.value&&handleOptionActivation(option)}));else{const commentTextArea=questionItem.querySelector(selectors_commentItem);commentTextArea&&(commentTextArea.value=response.value)}}}))})),!0))).catch(_notification.default.exception)};const registerEvents=()=>{document.addEventListener("change",(e=>{const ratingOption=e.target.closest(selectors_ratingOption);ratingOption&&ratingOption.checked&&handleOptionActivation(ratingOption)})),document.addEventListener("click",(e=>{const ratingOption=e.target.closest(selectors_ratingOption);if(ratingOption){const ratingOptionLabel=ratingOption.closest("label");ratingOptionLabel&&ratingOptionLabel.classList.add("focus")}})),document.addEventListener("blur",(e=>{const ratingOption=e.target.closest(selectors_ratingOption);if(ratingOption){const ratingOptionLabel=ratingOption.closest("label");ratingOptionLabel&&ratingOptionLabel.classList.remove("focus")}}));document.getElementById("save-feedback").addEventListener("click",(()=>{saveResponses(!1)}));document.getElementById("submit-feedback").addEventListener("click",(()=>{saveResponses(!0)}))},handleOptionActivation=ratingOption=>{const optionGroup=ratingOption.closest(selectors_questionItem),itemId=optionGroup.getAttribute("data-itemid");optionGroup.querySelectorAll(selectors_ratingOption).forEach((option=>{const optionLabel=option.nextElementSibling;optionLabel.classList.contains("btn-success")&&(optionLabel.classList.remove("btn-success"),optionLabel.classList.add("btn-secondary"),option.checked=!1)}));const selectedLabel=ratingOption.nextElementSibling;selectedLabel.classList.remove("btn-secondary"),selectedLabel.classList.remove("btn-info"),selectedLabel.classList.add("btn-success"),ratingOption.checked=!0,responses[itemId]=ratingOption.value},saveResponses=finalise=>{document.querySelectorAll(selectors_commentItem).forEach((comment=>{responses[comment.getAttribute("data-itemid")]=comment.value.trim()}));const questionnaireTable=document.querySelector(selectors_questionnaireTable),toUser=parseInt(questionnaireTable.getAttribute("data-touserid")),toUserFullname=questionnaireTable.getAttribute("data-tousername"),threesixtyId=parseInt(questionnaireTable.getAttribute("data-threesixtyid"));if(parseInt(questionnaireTable.getAttribute("data-anonymous"))&&finalise){const messageStrings=[{key:"finaliseanonymousfeedback",component:"mod_threesixo"},{key:"confirmfinaliseanonymousfeedback",component:"mod_threesixo",param:{name:toUserFullname}}];(0,_str.get_strings)(messageStrings,"mod_threesixo").then((messages=>showConfirmationDialogue(messages[0],messages[1],threesixtyId,toUser,responses,finalise))).catch(_notification.default.exception)}else submitResponses(threesixtyId,toUser,responses,finalise)},submitResponses=(threesixtyId,toUser,responses,finalise)=>{var promises=_ajax.default.call([{methodname:"mod_threesixo_save_responses",args:{threesixtyid:threesixtyId,touserid:toUser,responses:responses,complete:finalise}}]);let redirectUrl=null;promises[0].then((response=>response.result?(redirectUrl=response.redirurl,(0,_str.get_string)("responsessaved","mod_threesixo")):(0,_str.get_string)("errorresponsesavefailed","mod_threesixo"))).then((message=>(0,_toast.add)(message,{}))).then((()=>(finalise&&redirectUrl&&(window.location=redirectUrl),!0))).catch(_notification.default.exception)},showConfirmationDialogue=async(title,confirmationMessage,threesixtyId,toUser,responses,finalise)=>{const confirmButtonText=await(0,_str.get_string)("finalise","mod_threesixo"),confirmModal=await _modal_factory.default.create({title:title,body:confirmationMessage,large:!0,type:_modal_factory.default.types.SAVE_CANCEL});confirmModal.setSaveButtonText(confirmButtonText),confirmModal.show(),confirmModal.getRoot().on(_modal_events.default.hidden,(()=>{confirmModal.setBody("")})),confirmModal.getRoot().on(_modal_events.default.save,(()=>{submitResponses(threesixtyId,toUser,responses,finalise)}))}}));

//# sourceMappingURL=questionnaire.min.js.map