/**
 * Resource selector.
 *
 * @copyright  2018 Frédéric Massart
 * @author     Frédéric Massart <fred@branchup.tech>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define(["jquery","core/ajax","block_xp/throttler"],(function($,Ajax,Throttler){function ResourceSelector(container,searchFunction,searchTermFieldNode){this._eventNode=$("<div>"),this.container=$(container),this.searchId=0,this.searchTermNode=searchTermFieldNode,this.resultsContainer=container.find("tbody"),this.emptyResultsNode=container.find(".results-empty"),this.searchingResultsNode=container.find(".searching-results"),this.searchResultsNode=container.find(".search-results"),this.resourceTemplateNode=container.find(".resource-template"),this.resourceTemplateNode.hide(),this.resourceTemplate=this.resourceTemplateNode.clone(),this.resourceTemplate.removeClass("resource-template"),this.resourceTemplate.show(),this.throttler=new Throttler(300),this.searchFunction=searchFunction,this._setEventListeners(),this.minChars=3}return ResourceSelector.prototype.clear=function(){this.resultsContainer.empty()},ResourceSelector.prototype.displayEmptyResults=function(){this.searchingResultsNode.hide(),this.emptyResultsNode.show(),this.searchResultsNode.hide()},ResourceSelector.prototype.displayNothing=function(){this.searchingResultsNode.hide(),this.emptyResultsNode.hide(),this.searchResultsNode.hide()},ResourceSelector.prototype.displayResults=function(resources){resources&&resources.length?(this._publishResults(resources),this.searchingResultsNode.hide(),this.emptyResultsNode.hide(),this.searchResultsNode.show()):this.displayEmptyResults()},ResourceSelector.prototype.displaySearching=function(){this.searchingResultsNode.show(),this.emptyResultsNode.hide(),this.searchResultsNode.hide()},ResourceSelector.prototype.getResources=function(term){return $.when(this.searchFunction(term))},ResourceSelector.prototype.onResourceSelected=function(callback){this._eventNode.on("resource-selected",callback)},ResourceSelector.prototype.search=function(term){this.searchId+=1,this._performSearch(term,this.searchId)},ResourceSelector.prototype.setMinChars=function(minChars){this.minChars=minChars},ResourceSelector.prototype._onSearchTermKeyUp=function(e){var term=e.target.value;if("string"!=typeof term||term.length<this.minChars)return this.searchingResultsNode.hide(),void this.throttler.cancel();this.displaySearching(),this.searchId+=1,this.throttler.schedule(this._performSearchFactory(term,this.searchId))},ResourceSelector.prototype._onSelect=function(e){e.preventDefault();var resource=$(e.target).closest(".resource-node").data("resource");resource&&this._eventNode.trigger("resource-selected",resource)},ResourceSelector.prototype._performSearchFactory=function(term,searchId){return function(){this._performSearch(term,searchId)}.bind(this)},ResourceSelector.prototype._performSearch=function(term,scheduledSearchId){return this.getResources(term).then(function(data){this.searchId==scheduledSearchId&&this.displayResults(data)}.bind(this)).fail(function(){this.displayEmptyResults()}.bind(this))},ResourceSelector.prototype._publishResults=function(resources){this.clear(),resources.forEach(function(resource){var node=this.resourceTemplate.clone();node.find(".resource-name").text(resource.name),resource.subname?node.find(".resource-subname").text(resource.subname):node.find(".resource-subname").hide(),node.data("resource",resource),this.resultsContainer.append(node)}.bind(this))},ResourceSelector.prototype._setEventListeners=function(){this.searchTermNode.on("keyup",this._onSearchTermKeyUp.bind(this)),this.searchResultsNode.on("click","button",this._onSelect.bind(this))},ResourceSelector}));

//# sourceMappingURL=resource-selector.min.js.map