<?php
// This file is part of Exabis Eportfolio (extension for Moodle)
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.
// (c) 2016 GTN - Global Training Network GmbH <office@gtn-solutions.com>.

$string['translation:language'] = 'German';
$string['translation:person'] = 'Andreas Riepl';
$string['translation:organisation'] = 'IZ Steyr';
$string['translation:email'] = 'ariepl.work@gmail.com';

// === Main ===
// Shown in admin plugin list.
$string['pluginname'] = 'Exabis ePortfolio';
// === Shown in block title and all headers.
$string['blocktitle'] = 'Exabis ePortfolio';
$string['exaport:use'] = 'Nutzung';
$string['exaport:addinstance'] = 'Exabis ePortfolio zum Kurs hinzuf&uumlgen';
$string['exaport:myaddinstance'] = 'Exabis ePortfolie zur Startseite hinzuf&uumlgen';
$string['exaport:export'] = 'Export of SCORM-Files';
$string['exaport:import'] = 'Import of SCORM-Files';
$string['exaport:importfrommoodle'] = 'Import from Moodle';
$string['exaport:shareintern'] = 'Internal sharing of views';
$string['exaport:shareextern'] = 'External sharing of views';
$string['exaport:allowposts'] = 'Allow posting';
$string['exaport:competences'] = 'Allow competences';
$string['exaport:viewartifactsfromstudents'] = '';
$string['new'] = 'Neu';
$string['addbookmark'] = 'Bookmark hinzufügen';
$string['addcategory'] = 'Kategorie hinzufügen';
$string['attachment'] = 'Anhang';
$string['attachincluded'] = 'Anhang?';
$string['awaiting'] = '(\\$a wartend)';
$string['back'] = 'zurück';
$string['close'] = 'Schließen';
$string['backtocourse'] = 'zurück zum Kurs';
$string['categories'] = 'Kategorien';
$string['explaincategories'] = '<span class=\'block_eportfolio_bold\'>Kategorien:</span> hier können Sie die Kategorien einsehen und bearbeiten.';
$string['category'] = 'Kategorie';
$string['categoryhead'] = 'Bezeichnung der Kategorie';
$string['categorysaved'] = 'Kategorie hinzugefügt.';
$string['categoryedited'] = 'Kategorie gespeichert.';
$string['categorydeleted'] = 'Kategorie gel&ouml;scht.';
$string['date'] = 'Datum';
$string['dontincludeurl'] = 'Diese Option ausw&auml;hlen um die Verknüpfung zwischen Bookmark und URL aufzuheben';
$string['duplicatedurl'] = 'Diese URL ist bereits bei den Bookmarks vorhanden.';
$string['editcategories'] = 'Kategorien bearbeiten';
$string['explaining'] = 'Das ePortfolio-System kann verwendet werden um Webadressen, Dateien, Notizen und Kommentare zu verwalten.';
$string['explaininglink'] = '<span class=\'block_eportfolio_bold\'>Externe Links:</span> diese Links k&ouml;nnen mit anderen KursteilnehmerInnen ausgetauscht werden.';
$string['explainingfile'] = '<span class=\'block_eportfolio_bold\'>Dateien:</span> diese Dateien k&ouml;nnen mit anderen KursteilnehmerInnen ausgetauscht werden.';
$string['explainingnote'] = '<span class=\'block_eportfolio_bold\'>Notizen:</span> diese Notizen k&ouml;nnen mit anderen KursteilnehmerInnen ausgetauscht werden.';
$string['explainingshare'] = 'Um einem/einer anderen TeilnehmerIn den Link zu ver&ouml;ffentlichen, klicken Sie auf den jeweiligen Namen und speichern Sie dann die &Auml;nderungen.  Sie k&ouml;nnen mehr als eine/n TeilnehmerIn ausw&auml;hlen.';
$string['explainingshared'] = 'Folgende TeilnehmerInnen haben ver&ouml;ffentlichte Links, Dateien bzw. Notizen.';
$string['explainingsharefile'] = 'Um einem/einer anderen TeilnehmerIn die Datei zu ver&ouml;ffentlichen, klicken Sie auf den jeweiligen Namen und speichern Sie dann die &Auml;nderungen.  Sie k&ouml;nnen mehr als eine/n TeilnehmerIn ausw&auml;hlen.';
$string['explainingsharenote'] = 'Um einem/einer anderen TeilnehmerIn die Notiz zu ver&ouml;ffentlichen, klicken Sie auf den jeweiligen Namen und speichern Sie dann die &Auml;nderungen.  Sie k&ouml;nnen mehr als eine/n TeilnehmerIn ausw&auml;hlen.';
$string['file'] = 'Datei';
$string['iconfile_merge'] = 'Symbol mit Ordner-Symbol kombinieren';
$string['iconfile_merge_description'] = 'Symbolbild verknüpft sich mit dem Ordner-Symbol.';
$string['firstnameshared'] = 'Familienname';
$string['go'] = 'Go!';
$string['hidesummary'] = '(Gesamtaufstellung ausblenden)';
$string['managecategories'] = 'Kategorien verwalten';
$string['mandatoryfields'] = 'Eine Kategorienbezeichnung und eine kurze Beschreibung ist erforderlich. Bitte füllen Sie beides aus.';
$string['mandatoryfieldsforcat'] = 'Eine Feldbezeichnung ist erforderlich. Bitte füllen Sie diese aus.';
$string['myportfolio'] = 'Meine Portfolio Artefakte';
$string['myportfoliotitle'] = 'ePortfolio-Modul: Fügen Sie hier Links und Dateien hinzu.';
$string['newlink'] = 'Neuen externen Link hinzufügen';
$string['newfile'] = 'Neue Datei hinzufügen';
$string['newnote'] = 'Neue Notiz hinzufügen';
$string['nocategories'] = '(bisher gibt es noch keine Kategorien)';
$string['nobookmarksall'] = '(bisher gibt es noch keine Eintr&auml;ge)';
$string['nobookmarkslink'] = '(bisher gibt es noch keine Links)';
$string['nobookmarksfile'] = '(bisher gibt es noch keine Dateien)';
$string['nobookmarksnote'] = '(bisher gibt es noch keine Notizen)';
$string['noentry'] = 'Kein Eintrag';
$string['note'] = 'Notiz';
$string['notetitle'] = 'Notiz';
$string['shared_views'] = 'Geteilte Views';
$string['showall'] = 'auch andere Kurse anzeigen';
$string['showcourse'] = 'nur diesen Kurs anzeigen';
$string['showsummary'] = '(Gesamtaufstellung einblenden)';
$string['strshare'] = 'Ver&ouml;ffentlichen';
$string['strunshare'] = 'Ver&ouml;ffentlichung zurücknehmen';
$string['summary'] = 'Gesamtaufstellung (optional)';
$string['url'] = 'URL';
$string['maincategory'] = 'Hauptkategorie';
$string['subcategory'] = 'Unterkategorie';
$string['accessoptions'] = 'Wer hat Zugriff?';
$string['shareallexceptthose'] = 'Zugriff für <span class=\'block_eportfolio_bold\'>alle</span> (auch jene, die hier nicht angezeigt werden) au&szlig;er folgenden Benutzern';
$string['sharenoneexceptthose'] = 'Zugriff für <span class=\'block_eportfolio_bold\'>keine</span> au&szlig;er folgende Benutzer';
$string['internalaccessall'] = 'Zugriff für <span class=\'block_eportfolio_bold\'>alle</span>';
$string['internalaccessusers'] = 'Zugriff nur für folgende Benutzer';
$string['internalaccessgroups'] = 'Zugriff für folgende Gruppen';
$string['externaccess'] = 'externer ePortfolio-Link';
$string['emailaccess'] = 'Per Email teilen';
$string['emailaccessdescription'] = 'Geben Sie eine Email Adresse pro Zeile ein<br />Jede Adresse erhält einen eindeutigen Link mit Zugriff auf diese View. Das Löschen der Adresse löscht den Zugriff auf diese Veiw.';
$string['emailaccessmessagesubject'] = 'Eine View wurde mit dir geteilt';
$string['emailaccessmessage'] = 'Hallo! {$a->sendername} hat eine die View "{$a->viewname}" mit dir geteilt. Sie kann hier abgerufen werden: {$a->url}';
$string['emailaccessmessageHTML'] = 'Hallo!<br />{$a->sendername} hat eine die View "{$a->viewname}" mit dir geteilt.<br />Sie ist kann <a href="{$a->url}">hier</a> aberufen werden';
$string['showallusers'] = 'Zeige Benutzer aller meiner Kurse';
$string['showcourseusers'] = 'Zeige nur Benutzer des aktuellen Kurses';
$string['sharedpersons'] = 'Personen mit ver&ouml;ffentlichten Portfolios';
$string['moodleimport'] = 'Import aus Moodle-Aufgaben';
$string['nomoodleimportyet'] = 'Im Moment sind noch keine Abgaben vorhanden!';
$string['deletecategoryconfirm'] = 'Wollen Sie die Kategorie "{$a->name}" wirklich l&ouml;schen? Es werden alle Eintr&auml;ge in dieser Kategorie und alle Unterkategorien mitgel&ouml;scht!';
$string['name'] = 'Name';
$string['role'] = 'Rolle';
$string['nousersfound'] = 'Keine Benutzer gefunden';
$string['delete'] = 'L&ouml;schen';
$string['add'] = 'Hinzufügen';
$string['edit'] = 'Editieren';
$string['checkall'] = 'Alle auswählen';
$string['grouptitle'] = 'Gruppentitel';
$string['membercount'] = 'Anzahl von Mitgliedern';
$string['nogroupsfound'] = 'Keine Gruppen gefunden';
$string['make_it_yours'] = 'Mach\' es zu deinem Eigenen';

// === Export/import.
$string['import'] = 'Import SCORM-Datei';
$string['import_short'] = 'Import';
$string['explainexport'] = '<span class=\'block_eportfolio_center\'><span class=\'block_eportfolio_bold\'>Export:</span> hier k&ouml;nnen Sie Ihr ePortfolio exportieren</span>';
$string['createexport'] = 'SCORM-Datei erstellen';
$string['clicktodownloadscorm'] = 'Folgenden Button drücken, um SCORM-Datei herunterzuladen:';
$string['add_directory_structure'] = 'Mit Unterverzeichnissen exportieren';
$string['download'] = 'Herunterladen';
$string['endedit'] = 'Editieren beenden';
$string['change'] = '&auml;ndern';
$string['explainpersonal'] = '<span class=\'block_eportfolio_bold\'>Pers&ouml;nliche Informationen</span>';
$string['personal'] = 'Informationen';
$string['descriptionsaved'] = 'Beschreibung gespeichert';
$string['course'] = 'Kurs';
$string['importexport'] = 'Import/Export';
$string['explainimport'] = 'hier k&ouml;nnen Sie SCORM-Dateien ins Portfolio importieren. Wenn Marker gefunden werden, die darauf hinweisen, dass diese SCORM-Datei zuvor aus dem Portfolio-Modul exportiert wurde, so wird versucht, die Stuktur entsprechend zu importieren.';
$string['makeimport'] = 'Import';
$string['add_this_file'] = 'Diese Datei hinzufügen';
$string['bookmarksall'] = 'Alle Eintr&auml;ge';
$string['bookmarkslinks'] = 'Links';
$string['bookmarksfiles'] = 'Dateien';
$string['bookmarksnotes'] = 'Notizen';
$string['noguestpost'] = 'G&auml;ste haben hier keinen Zugriff!';
$string['comments'] = 'Kommentare';
$string['addcomment'] = 'Kommentar hinzufügen';
$string['externcomment'] = 'Kommentare mitver&ouml;ffentlichen';
$string['itemgrading'] = 'Beurteilung';
$string['gradeitem'] = 'Abgabe beurteilen';
$string['submititem'] = 'Abgeben';
$string['saveitem'] = 'Speichern';

// === Notes.
$string['deletenoteconfirm'] = 'Wollen Sie diese Notiz wirklich l&ouml;schen?';
$string['deletelinkconfirm'] = 'Wollen Sie diesen Link wirklich l&ouml;schen?';
$string['deletefileconfirm'] = 'Wollen Sie diese Datei wirklich l&ouml;schen?';

// === Different.
$string['couldninsertcomment'] = 'Kommentar konnte nicht eingefügt werden!';
$string['importedcommentsstart'] = 'Importierte Kommentare:<br /><br />';
$string['importedcommentsend'] = 'Ende importierte Kommentare';
$string['filetypenotdetected'] = 'Filetyp von $a->filename ($a->title) konnte nicht ermittelt werden. Datei wurde nicht importiert!';
$string['linkedfilenotfound'] = 'Datei $a->filename in $a->url ($a->title) wurde nicht gefunden. Datei wurde nicht importiert!';
$string['couldntinsert'] = 'Konnte $a nicht in der Datenbank einfügen';
$string['couldntcreatedirectory'] = 'Verzeichnis konnte nicht erstellt werden';
$string['couldntcopyfile'] = 'Konnte Datei $a nicht kopieren! Datei wurde nicht importiert!';
$string['success'] = 'Datei erfolgreich importiert';
$string['couldntinsertcategory'] = 'Kategorie konnte nicht eingefügt werden!';
$string['couldntupdatecategory'] = 'Kategorie konnte nicht aktualisiert werden!';
$string['couldntextractscormfile'] = 'SCORM-Datei konnte nicht extrahiert werden!';
$string['couldntcreatetempdir'] = 'Tempor&auml;res Verzeichnis konnte nicht erstellt werden.!';
$string['scormhastobezip'] = 'SCORM-Datei muss im zip-Format vorliegen!';
$string['uploadfailed'] = 'Upload nicht erfolgreich!';
$string['couldntupdatedesc'] = 'Beschreibung konnte nicht aktualisiert werden!';
$string['couldntinsertdesc'] = 'Beschreibung konnte nicht eingefügt werden!';
$string['exportcomment'] = 'Das ist eine exportierte Datei von exabis ePortfolio. Bitte entfernen Sie die Kommentare nicht, da sie sonst nicht mehr mitimportiert werden k&ouml;nnen!';
$string['comment'] = 'Kommentar';
$string['commentshouldnotbeempty'] = 'Der Kommentar darf nicht leer sein.';
$string['title'] = 'Titel';
$string['titlenotemtpy'] = 'Der Titel darf nicht leer sein.';
$string['intro'] = 'Inhalt';
$string['intronotempty'] = 'Der Inhalt darf nicht leer sein.';
$string['link'] = 'Link';
$string['categorynotempty'] = 'Es muss eine Kategorie ausgew&auml;hlt sein.';
$string['urlnotempty'] = 'Die URL darf nicht leer sein.';
$string['selectall'] = 'Alle markieren';
$string['deselectall'] = 'Alle Markierungen l&ouml;schen';
$string['internalaccess'] = 'Interner Zugriff';
$string['externalaccess'] = 'Externer Zugriff';
$string['loginasmode'] = 'Sie haben als Administrator keine Zugriff auf fremde Portfolios';
$string['badsessionkey'] = 'Session nicht mehr gültig';
$string['invalidinstance'] = 'Ungültige Instanz';
$string['invalidcourseid'] = 'Ungültige Kursnummer';
$string['wronglinkid'] = 'Falsche Link-Id';
$string['incorrectlinksid'] = 'Falsche Links-Post Id';
$string['incorrectnoteid'] = 'Falsche Notizen Id';
$string['unknownaction'] = 'Unbekannte Aktion';
$string['filenotfound'] = 'Datei nicht gefunden';
$string['wrongfileid'] = 'Falsche Datei Id';
$string['wrongfilepostid'] = 'Falsche Datei-Post Id';
$string['wrongnoteid'] = 'Falsche Notiz Id';
$string['wrongnotepostid'] = 'Falsche Notiz-Post Id';
$string['bookmarknotfound'] = 'Bookmark nicht gefunden';
$string['commentnotfound'] = 'Kommentar nicht gefunden';
$string['updateposterror'] = 'Posting konnte in Datenbank nicht aktualisiert werden';
$string['deleteposterror'] = 'Fehler beim L&ouml;schen des Postings';
$string['addposterror'] = 'Posting konnte in Datenbank nicht hinzugefügt werden';
$string['invalidassignmentid'] = 'Falsche Abgabe-Id';
$string['invalidfileatthisassignment'] = 'Datei existiert nicht zu dieser Abgabe!';
$string['publishedportfolios'] = 'Ver&ouml;ffentliche Portfolios';
$string['viewcategories'] = 'Kategorien verwalten';
$string['updownarrow'] = 'Pfeil nach oben/nach unten';
$string['comment_delete_confirmation'] = 'Wollen Sie wirklich diesen Kommentar löschen?';

// Shared portfolios.
$string['nocoursetogether'] = 'Kein Kurs';
$string['nothingshared'] = 'Kein freigegebenen ePortfolios gefunden';

// === Errors.
$string['nouserforid'] = 'Kein Benutzer zu dieser Id!';
$string['nouserforaccess'] = 'Benutzer nicht gefunden (Zugriffscode unbekannt)';

// === Export.
$string['export'] = 'Export SCORM-Datei';
$string['export_short'] = 'Export';
$string['exportepx'] = 'Export EPX-Datei';
$string['createepxexport'] = 'EPX-Datei erstellen';
$string['exportviewselect'] = 'Um alle Einträge einer bestimmten View zu exportieren, bitte diese hier w&auml;hlen';
$string['export_directory'] = 'Exportiere Ordnerstruktur';
$string['createexport_directory'] = 'Erstelle Ordnerstruktur';

// === Stuff.
$string['type'] = 'Typ';
$string['share'] = 'Share';
$string['explainingall'] = 'Alle Eintr&auml;ge im Portfolio';
$string['share_to_other_users'] = 'Benutzer suchen';
$string['other_users_course'] = 'Benutzer, die nicht in meinen Kursen sind';
$string['other_groups_course'] = 'Andere Kurse';

// === Item sorting.
$string['userdefinedsort'] = 'Eigene Sortierung vornehmen';
$string['movetop'] = 'An erste Stelle';
$string['movebottom'] = 'An letzte Stelle';

// === Views.
$string['view'] = 'View';
$string['views'] = 'Meine Views';
$string['explainingviews'] = 'View verwalten';
$string['noviews'] = 'Bitte Views anlegen';
$string['viewnotfound'] = 'Das Objekt ist für den Benutzer nicht einsehbar / Keine Zugriffsberechtigung.';
$string['newview'] = 'Neue View erstellen';
$string['viewinformation'] = 'View Informationen';
$string['viewdescription'] = 'Beschreibung';
$string['viewdesign'] = 'View Darstellung';
$string['viewitems'] = 'Deine Eintr&auml;ge';
$string['viewitem'] = 'Eintrag';
$string['view_specialitems'] = 'Spezielle Eintr&auml;ge';
$string['view_specialitem_headline'] = 'Kopfzeile';
$string['view_specialitem_personal'] = 'Persönliche Information';
$string['view_specialitem_text'] = 'Text';
$string['view_specialitem_media'] = 'Medieneintrag';
$string['view_specialitem_badge'] = 'Badge';
$string['view_specialitem_headline_defaulttext'] = 'Kopfzeile hier eingeben';
$string['view_specialitem_text_defaulttext'] = 'Text hier eingeben';
$string['view_sharing'] = 'Ver&ouml;ffentlichen';
$string['viewand'] = 'und';
$string['view_sharing_noaccess'] = 'Kein Zugriff';
$string['show'] = 'Anzeigen';
$string['thiscourse'] = 'Aktueller Kurs';
$string['othercourses'] = 'Andere Kurse';
$string['autofillview'] = 'Alle bestehenden Artefakte in diese View einfügen';
$string['sharetoteacher'] = 'Sofort mit allen Kurs-Trainer/innen teilen';
$string['createpage'] = 'Zieh das Elemente in das Feld unterhalb, um deinen Inhalt zu erstellen.';
$string['chooselayout'] = 'W&aumlhle ein Layout für deinen View.';
$string['viewtitle'] = 'Titel und Beschreibung';
$string['viewcontent'] = 'Inhalt';
$string['viewlayout'] = 'Layout';
$string['viewshare'] = 'Teilen';
$string['viewlayoutgroup1'] = '1 Spalte';
$string['viewlayoutgroup2'] = '2 Spalten';
$string['viewlayoutgroup3'] = '3 Spalten';
$string['viewlayoutgroup4'] = '4 Spalten';
$string['viewlayoutgroup5'] = '5 Spalten';
$string['viewlayout1'] = 'Gleiche Breite';
$string['viewlayout2'] = 'Gleiche Breite';
$string['viewlayout3'] = 'Linke Spalte breiter';
$string['viewlayout4'] = 'Rechte Spalte breiter';
$string['viewlayout5'] = 'Gleiche Breite';
$string['viewlayout6'] = 'Mittlere Spalte breiter';
$string['viewlayout7'] = 'Mittlere Spalte viel breiter';
$string['viewlayout8'] = 'Gleiche Breite';
$string['viewlayout9'] = 'Mittlere Spalte breiter';
$string['viewlayout10'] = 'Gleiche Breite';
$string['personalinformation'] = 'Persönliche Information';
$string['cvinformation'] = 'Lebenslauf Information';
$string['headertext'] = 'Kopfzeile';
$string['item'] = 'Artefakt';
$string['items'] = 'Artefakte';
$string['media'] = 'Medieneintrag';
$string['fieldstoshow'] = 'Anzuzeigende Felder';
$string['listofartefacts'] = 'W&aumlhle ein Element aus';
$string['listofbadges'] = 'Liste von Badges';
$string['addButton'] = 'Hinzufügen';
$string['saveButton'] = 'Speichern';
$string['cancelButton'] = 'Abbrechen';
$string['blocktitle2'] = 'Blocktitel';
$string['blockcontent'] = 'Blockinhalt';
$string['firstname'] = 'Vorname';
$string['lastname'] = 'Nachname';
$string['profilepicture'] = 'Profilbild';
$string['nopicture'] = 'kein Bild';
$string['noprofilepicture'] = 'kein Bild verfügbar';
$string['mailadress'] = 'E-Mail-Adresse';
$string['nomail'] = 'keine Mail-Adresse';
$string['noemails'] = 'keine Mail-Adresse vorhanden';
$string['aboutme'] = 'Über mich';
$string['notify'] = 'benachrichtigen';
$string['sharejs'] = 'teilen';
$string['mediacontent'] = 'URL oder eingebetteter Code*';
$string['height'] = 'H&ouml;he';
$string['width'] = 'Breite';
$string['media_allowed_notes'] = 'URLs der folgenden Seiten sind erlaubt:';
$string['filterByTag'] = 'Tag zum Filtern verwenden';
$string['tagarea_block_exaportitem'] = 'Meine Portfolio Artefakte';
$string['searchByTitle'] = 'Suchen';
$string['clearAllFilers'] = 'Alle Filter zurücksetzen';
$string['sharedwith'] = 'Geteilt mit';
$string['sharedwith_user_cnt'] = 'Mit {$a} Benutzern geteilt';
$string['sharedwith_onlyme'] = 'Nur mit mir geteilt';
$string['sharedwith_shareall'] = 'Mit allen Benutzer:innen geteilt';
$string['sharedwith_shareexternal'] = 'Geteilte externe Views';
$string['sharedwith_group'] = 'Mit meiner Gruppe geteilt';
$string['sharedwith_group_cnt'] = 'Mit {$a} Gruppe geteilt';

// === Copy to course.
$string['filecopiedtocourse'] = 'Datei wurde in den Kurs $a->coursename unter dem Namen $a->filename kopiert';
$string['copyitemtocourse'] = 'In Kurs kopieren';
$string['desp_language'] = 'Desp Sprache';
$string['cofigureblock'] = 'Konfigurationsblock';
$string['selectitems'] = 'W&aumlehle Elemente aus';
$string['cofigureblock_text'] = 'Text';
$string['cofigureblock_header'] = 'Konfiguration der Kopfzeile';
$string['cofigureblock_item'] = 'Auswahl der Artefakte';
$string['cofigureblock_media'] = 'Medieneintrag';
$string['cofigureblock_personalinfo'] = 'Pers&ouml;nliche Information';
$string['cofigureblock_cvinfo'] = 'Lebenslauf Information';
$string['cofigureblock_badge'] = 'Badges auswählen';
$string['cofigureblock_cvinfo_education_history'] = 'Bildungs-Karriere';
$string['cofigureblock_cvinfo_employment_history'] = 'Bildungs-Karriere';
$string['cofigureblock_cvinfo_certif'] = 'Zertifikate, Akkreditierungen, Auszeichnungen';
$string['cofigureblock_cvinfo_public'] = 'Bücher und Publikationen';
$string['cofigureblock_cvinfo_mbrship'] = 'Mitgliedschaften';
$string['cofigureblock_cvinfo_goals'] = 'Meine Ziele';
$string['cofigureblock_cvinfo_skills'] = 'Meine Kompetenzen';
$string['cofigureblock_cvinfo_interests'] = 'Interessen';
$string['in'] = 'at';
$string['cofigureblock_cvinfo_withfiles'] = 'mit Anhängen publizieren';

// === Desp.
$string['back_to_desp'] = 'zurück zum d-ESP';
$string['desp_pluginname'] = 'Dossier';
$string['steckbrief'] = 'Steckbrief';
$string['desp_categories'] = '
    Erzählungen, Rollenspielszenen, Gedichte, Collagen
    Lebenslauf
    Berichte über Theateraufführungen, Ausstellungen
    Berichte über Projekte, Projektreflexionen
    Audio- und Videoclips
    Begegnungen durch Reisen in andere Länder
    Überlegungen zu deinem Sprachenlernen
    Zeugnisse
    Zertifikate
    Bestätigungen
    Hören
    Einzelarbeit
    Partnerarbeit
    Gruppenarbeit
    Lesen
    Einzelarbeit
     - Partnerarbeit
     - Gruppenarbeit
    An Gesprächen teilnehmen
     - Einzelarbeit
     - Partnerarbeit
     - Gruppenarbeit
    Zusammenhängend sprechen
     - Einzelarbeit
     - Partnerarbeit
     - Gruppenarbeit
    Schreiben
     - Einzelarbeit
     - Gruppenarbeit
     - Partnerarbeit
';

// === Config.
$string['config_feature_copy_to_course'] = 'Schüler dürfen Dateien in den Kurs kopieren';
$string['competenceinteraction'] = 'Interaktion mit Block Exabis Competence Grid, falls dieser installiert ist, zulassen.';
$string['opencomps'] = 'Kompetenzen auswählen';
$string['selectcomps'] = 'W&auml;hle hier die Kompetenzen, die zu deinem Upload passen!';
$string['competences_old_version'] = 'Auf diesem Moodle ist eine alte Version von Exabis Competences installiert. Diese wird von Exabis Eportfolio nicht mehr unterstützt.';
$string['expandcomps'] = 'Alle &ouml;ffnen';
$string['contactcomps'] = 'Alle schlie&szlig;en';
$string['studentcomps'] = 'Hier kannst du einsch&auml;tzen, ob folgende Kompetenzen durch Dein Artefakt erreicht wurden.';
$string['teachercomps'] = 'Hier k&ouml;nnen Sie beurteilen, ob der Schüler folgende Kompetenzen durch sein Artefakt erreicht hat.';
$string['competences'] = 'Kompetenzen';
$string['desp_einleitung'] = 'Hier ist nun meine Sammelmappe, mein Dossier. Hier kann ich anderen zeigen, was ich alles gemacht habe. Ich kann genau sehen, wie viel ich schon gelernt habe.';
$string['settings_interaktion_exacomp_head'] = 'Interaktion exabis ePortfolio - Exabis Competence Grid';
$string['settings_interaktion_exacomp_body'] = 'Interaktion mit Block Exabis Competence Grid, falls dieser installiert ist, zulassen.';
$string['settings_allow_loginas_head'] = '"Login als" erlauben';
$string['settings_allow_loginas_body'] = '';
$string['settings_create_desp_categories_head'] = 'Create Desp Categories';
$string['settings_create_desp_categories_body'] = '';
$string['settings_disable_shareall_head'] = 'Mit allen Benutzer:innen teilen deaktivieren';
$string['settings_disable_shareall_body'] = 'Klicken Sie <a href="{$a}">hier</a> um alle globalen Freigaben zu löschen';
$string['settings_disable_external_comments_head'] = 'Teilen von Kommentaren in externen Views deaktivieren';
$string['settings_disable_external_comments_body'] = '';
$string['block_exaport_app_externaleportfolio_head'] = 'Dateien in Mahara speichern';
$string['block_exaport_app_externaleportfolio_body'] = 'App: Setze das Häkchen um Dateien in Mahara zu speichern, ansonsten werden Datein im exabis ePortfolio hinterlegt.';
$string['block_exaport_maxbytes'] = 'Maximale Upload-Dateigröße in Exabis ePortfolio';
$string['block_exaport_maxbytes_body'] = 'Maximale Dateigröße, die Dateien haben können, die im Exabis ePortfolio hochgeladen werden. <br> Wert für diese Seite ist: {$a->sitemaxbytes}. Siehe <a href="{$a->settingsurl}">Einstellungen</a>';
$string['block_exaport_userquota'] = 'Benutzer-Dateikontingent Exabis ePortfolio';
$string['block_exaport_userquota_body'] = 'Maximale Anzahl an Bytes, die ein Benutzer im Exabis ePortfolio hochladen kann. <br> Wert für diese Seite ist: {$a->bytes}. Siehe <a href="{$a->settingsurl}">Einstellungen</a>';
$string['block_exaport_multiplefilesinitem'] = 'Mehrere Dateien in Datei-Artefakt hochladen';
$string['block_exaport_multiplefilesinitem_body'] = 'limit: 10 Dateien';
$string['block_exaport_copytomyportfolio'] = 'Enable "Copy to my portfolio"';
$string['block_exaport_copytomyportfolio_body'] = 'User will be able copy artifacts from shared category into own portfolio';
$string['block_exaport_app_alloweditdelete_head'] = 'Schüler/innen dürfen trotz Lehrerbeurteilungen ePortfolio Items editieren und löschen';
$string['block_exaport_app_alloweditdelete_body'] = 'Nur in Kombination mit Exabis Competence Grid und Dakora sinnvoll';
$string['delete_all_shareall'] = 'Alle globalen Freigaben "shareall" löschen?';
$string['block_exaport_teachercanseeartifactsofstudents_head'] = 'Trainer/in hat Zugriff auf alle Artefakte eigene Schüler/innen';
$string['block_exaport_teachercanseeartifactsofstudents_body'] = 'Vertrauenswürdige Trainer/innen müssen im jeweiligen Profil als solche definiert werden. Dies funktioniert nur, wenn obige Option aktiviert ist.<br />{$a}Die Liste der Teilnehmer/innen für jede/n als vertrauenswürdig definierte/n Trainer/in generiert sich automatisch durch Kurseinschreibungen<br />Teilnehmer/innen können diesen Zugriff nicht deaktivieren. Dies hat keine Auswirkungen auf die Gewährung von Zugriffen für andere Teilnehmer/innen.';
$string['block_exaport_teachercanseeartifactsofstudents_configurationlink'] = 'erforderliches Profilfeld für vertrauenswürdigen Trainer erstellen';
$string['block_exaport_confirm_profilefield_create'] = 'Wollen Sie wirklich das Profilfeld für vertrauenswürdige Trainer erstellen?';
$string['block_exaport_confirm_profilefield_exists'] = 'Das erforderliche Feld existiert bereits';
$string['block_exaport_profilefield_created'] = 'Das erforderliche Feld wurde hinzugefügt';

// === Resume.
$string['resume_template_newresume'] = '<h2>Mein Lebenslauf</h2>';
$string['resume_my'] = 'Mein Lebenslauf';
$string['resume_cover'] = 'Begleit-Informationen';
$string['resume_coversaved'] = 'Begleit-Informationen gespeichert';
$string['resume_eduhistory'] = 'Bildungs-Karriere';
$string['resume_edu'] = 'Bildung';
$string['resume_edusaved'] = 'Bildungsverlauf gespeichert';
$string['resume_deleteeduconfirm'] = 'Wollen Sie wirklich den Eintrag löschen?';
$string['resume_edudeleted'] = 'Eintrag gelöscht';
$string['resume_employhistory'] = 'Beschäftigungs-Historie';
$string['resume_employ'] = 'Beschäftigung';
$string['resume_employsaved'] = 'Beschäftigung gespeichert';
$string['resume_deleteemployconfirm'] = 'Wollen Sie wirklich den Eintrag löschen?';
$string['resume_employdeleted'] = 'Beschäftigung gelöscht';
$string['resume_interests'] = 'Interessen';
$string['resume_interestssaved'] = 'Interessen gespeichert';
$string['resume_startdate'] = 'Start-Datum';
$string['resume_enddate'] = 'End-Datum';
$string['resume_institution'] = 'Bildungseinrichtung';
$string['resume_institutionaddress'] = 'Adresse der Bildungseinrichtung';
$string['resume_qualification'] = 'Qualifikation';
$string['resume_qualtype'] = 'Art der Qualifikation';
$string['resume_qualname'] = 'Bezeichnung der Qualifikation';
$string['resume_qualdescription'] = 'Beschreibung der Qualifikation';
$string['resume_files'] = 'Anhang';
$string['resume_employer'] = 'Arbeitgeber';
$string['resume_employeraddress'] = 'Adresse des Arbeitgebers';
$string['resume_jobtitle'] = 'Job-Titel';
$string['resume_position'] = 'Position';
$string['resume_positiondescription'] = 'Beschreibung der Position';
$string['resume_certif'] = 'Zertifikate, Akkreditierungen, Auszeichnungen';
$string['resume_date'] = 'Datum';
$string['resume_title'] = 'Title';
$string['resume_description'] = 'Beschreibung';
$string['resume_certifsaved'] = 'Zertifikat, Akkreditierung bzw. Auszeichnung gespeichert';
$string['resume_deletecertifconfirm'] = 'Wollen Sie wirklich den Eintrag löschen?';
$string['resume_certifdeleted'] = 'Zertifikat, Akkreditierung bzw. Auszeichnung gelöscht';
$string['resume_public'] = 'Bücher und Publikationen';
$string['resume_contribution'] = 'Beiträge';
$string['resume_contributiondetails'] = 'Details zum Beitrag';
$string['resume_url'] = 'URL';
$string['resume_publicsaved'] = 'Bücher und Publikationen gespeichert';
$string['resume_deletepublicconfirm'] = 'Wollen Sie wirklich den Eintrag löschen?';
$string['resume_publicdeleted'] = 'Buch oder Publikation gelöscht';
$string['resume_mbrship'] = 'Mitgliedschaften';
$string['resume_mbrshipsaved'] = 'Mitgliedschaften gespeichert';
$string['resume_deletembrshipconfirm'] = 'Wollen Sie wirklich den Eintrag löschen?';
$string['resume_mbrshipdeleted'] = 'Mitgliedschaft gelöscht';
$string['resume_linkedin'] = 'LinkedIn-Profil';
$string['resume_linkedinsaved'] = 'LinkedIn-Profil gespeichert';
$string['resume_deletelinkedinconfirm'] = 'Wollen Sie wirklich den Eintrag löschen?';
$string['resume_linkedindeleted'] = 'LinkedIn-Profil gelöscht';
$string['resume_mygoals'] = 'Meine Ziele';
$string['resume_goals'] = 'Ziele';
$string['resume_goalspersonal'] = 'persönliche Ziele';
$string['resume_goalsacademic'] = 'Bildungsziele';
$string['resume_goalscareers'] = 'Karriereziele';
$string['resume_goalspersonalsaved'] = 'Persönliche Ziele gespeichert';
$string['resume_goalsacademicsaved'] = 'Bildungsziele gespeichert';
$string['resume_goalscareerssaved'] = 'Karriereziele gespeichert';
$string['resume_myskills'] = 'Meine Kompetenzen';
$string['resume_skills'] = 'Kompetenzen';
$string['resume_skillspersonal'] = 'Persönliche Kompetenzen';
$string['resume_skillsacademic'] = 'Bildungs-Kompetenzen';
$string['resume_skillscareers'] = 'Karriere-Kompetenzen';
$string['resume_skillspersonalsaved'] = 'Persönliche Kompetenzen gespeichert';
$string['resume_skillsacademicsaved'] = 'Bildungs-Kompetenzen gespeichert';
$string['resume_skillscareerssaved'] = 'Karriere-Kompetenzen gespeichert';
$string['resume_goalscomp'] = 'Kompetenzen';
$string['resume_skillscomp'] = 'Kompetenzen';
$string['resume_badges'] = 'Moodle-Auszeichnungen';
$string['resume_exportto_europass'] = 'Export für Europass';
$string['resume_exportto_europass_intro'] = '<p>Das Tool hilft den Nutzerinnen und Nutzern bei der Ermittlung von Lern- und Karrieremöglichkeiten. Im Hinblick auf Beratung und Service-Angebot ist das Profil auch für Arbeitgeber, Freiwilligenorganisationen, Recruiter/innen, Laufbahnberater/innen, Jugendorganisationen, Bildungseinrichtungen und andere Organisationen interessant.</p>
        <p>We provide a way for using your CV from Exabis eProtfolio in Europass profile<br>
            The generated XML-file has to be inserted into the page <a href="https://europa.eu/europass/eportfolio/screen/cv-editor?lang=de" target="_blank">Hier kannst du deinen Lebenslauf erstellen</a><br>
            (better to be logged in in the Europass previously)<br>
            Press the button "<strong>Europass-Lebenslauf importieren</strong>" and upload XML-file wich will genareted the button below
        </p>

    Ein paar Kurznotizen:<br>
    <ul><li>Der generierte Lebenslauf sollte auf alle Fälle nochmals kontrolliert werden</li>
        <li>Persönliche Daten werden aus den persönlichen Moodle-Informationen generiert</li>
        <li>Alle Datumsangaben sollten überprüft werden</li>
        <li>Bilder die über die HTML-Editoren eingefügt wurden werden nicht exportiert</li>
        <li>Texte die über die HTML-Editoren eingefügt wurden müssen unter Umständen neu formatiert werden</li>
        <li>Vorgaben für angehängte Dateien: Formate PDF, PNG, JPG sind erlaubt, maximale Dateigröße: 2,5 MB.</li>
    </ul>';
$string['resume_exportto_europass_getXML'] = 'XML herunterladen';
$string['resume_expand'] = 'Alles öffnen';
$string['resume_collaps'] = 'Alles schließen';

// === Structure sharing.
$string['shared_categories'] = 'Geteilte Kategorien';
$string['nothingstructureshared'] = 'Keine geteilten Strukturen';
$string['browsecategory'] = 'Inhalt anzeigen';
$string['copycategory'] = 'In mein Portfolio kopieren';
$string['sharedArtefacts'] = 'Gruppe-Portfolios, die mit dir geteilt wurden';
$string['shareditems_category'] = 'Gruppen-Portfolios, die mit dir geteilt wurden';
$string['create_as_note'] = 'Als Artefakt hinzufügen';
$string['category_not_found'] = 'Kategorie nicht gefunden';
$string['root_category'] = 'Hauptkategorie';
$string['current_category'] = 'Aktuelle Kategorie';
$string['change_layout'] = 'Darstellung wechseln';
$string['details'] = 'Details';
$string['tiles'] = 'Kacheln';
$string['category_up'] = 'übergeordnete Kategorie';
$string['supported'] = 'Projekt wurde unterstützt von';
$string['developed'] = 'entwickelt von';
$string['myfilearea'] = 'Mein Dateibereich';
$string['show_mystudents'] = 'Meine Teilnehmer/innen';
$string['show_sharedbyuser'] = 'von Teilnehmer/innen geteilt';
$string['enrolled_courses'] = 'mit folgenden Kursen verknüpft';
$string['browseportfolio'] = 'Inhalt anzeigen';

// === Language categories.

// === Message.
$string['messageprovider:sharing'] = 'Nachricht, wenn ein Benutzer/in etwas mit mir teilt';

// === Not Used Anymore.
$string['i_shared'] = 'Ich habe eine View mit Ihnen geteilt';
$string['addstdcat'] = 'Standardkategorien importieren';
$string['incompatible_video'] = 'Um dieses Video anzusehen, bitte den direkten Link benutzen: {$a->link}';
$string['download_pdf'] = 'Download as Pdf';
$string['pdf_settings'] = 'PDF-Einstellungen';
$string['pdf_settings_description'] = 'If you use some special or uncommon language characters the generated pdf can have problems. So, you can try to use different font settings<br>
            Your PDF settings will be saved for this view.<br>So, if your view is shared with other users - they will see the pdf with your settings.<br>
            Non-standard fonts can have some lost options like bold, italic, e.t.c.';
$string['pdf_settings_fontfamily'] = 'Schriftfamilie';
$string['pdf_settings_fontsize'] = 'Grundlegende Schriftgröße';
$string['pdf_settings_showmetadata'] = 'Add view meta data';
$string['pdf_settings_showusername'] = 'user name';
$string['pdf_settings_showuserpicture'] = 'user picture';
$string['pdf_settings_showuseremail'] = 'user email';
$string['pdf_settings_showuserphone'] = 'user phone';
$string['pdf_customfont'] = 'Upload custom font';
$string['pdf_settings_uploadfont'] = 'Eigene Schriftart hochladen';
$string['pdf_settings_pagesize'] = 'Seitengröße';
$string['pdf_settings_pageorient'] = 'Seitenausrichtung';
$string['pdf_settings_pageorient.portrait'] = 'Hochformat';
$string['pdf_settings_pageorient.landscape'] = 'Querformat';
$string['pdf_customfont_help'] = 'Your can upload own .ttf file. We will try to use it for PDF generation.';
$string['pdf_settings_fontfamily_fixedgroup'] = 'Predefined fonts';
$string['pdf_settings_fontfamily_customgroup'] = 'Custom uploaded fonts';
$string['selected_competencies'] = 'Erreichte Kompetenz';
$string['forms.item.title'] = 'Titel';
$string['forms.item.title_help'] = 'Titel help text';
$string['view_saved'] = 'View gespeichert';
$string['view_sharing_updated'] = 'Ver&ouml;ffentlichung gespeichert';
$string['list'] = 'Liste';
$string['what_is_embed_code_title'] = 'What is embed code?';
$string['what_is_embed_code_content'] = '<p>Embed code is code that is generated by a third-party website such as YouTube or Twitter, that a user can copy and paste into his or her own webpage.  This embedded code will then show the same media, application, or feed on the user\'s web page as it does in the original source.</p>
            <p>We provide instructions for the most popular video vendors such as YouTube or Vimeo.</p>
            <p><strong>Finding the embed code on YouTube:</strong></p>
            <ol>
                <li>Go to YouTube</a>.</li>
                <li>Navigate to the video you wish to embed.</li>
                <li>Click the <strong>Share link</strong> below the video, then click the <strong>Embed link</strong>.</li>
                <li>Press <strong>Copy</strong> button in the footer of opened window.</li>
                <li>The embed link will be highlighted in blue and copied to the clipboard.</li>
                <li>Past the code to exabis E-portfolio textarea field.</li>
            </ol>
            <p><strong>Finding the embed code on Vimeo:</strong></p>
            <ol>
                <li>Go to Vimeo.</li>
                <li>Navigate to the video you wish to embed.</li>
                <li>Click the <strong>Share</strong> button, in the top right corner of your video.</li>
                <li>A pop-up will appear with the embed link information. You will need to copy only the <strong>&lt;<i>iframe</i>&gt;</strong> portion of the embed link.
                    Example:<br>                    
                    <ol>
                        <li>
                            Entire embed link shows the following:<br>
                            <textarea disabled=\'true\' style=\'border: none;background-color:white;width:100%;font-size:0.75em;\'>&lt;iframe src=&quote;https://player.vimeo.com/video/1233456789&quote; width=&quote;640&quote; height=&quote;360&quote; frameborder=&quote;0&quote; allow=&quote;autoplay; fullscreen&quote; allowfullscreen&gt;&lt;/iframe&gt;&lt;p&gt;&lt;a href=&quote;https://vimeo.com/1233456789&quote;&gt;1- Automation Opening[2]&lt;/a&gt; from &lt;a href=&quote;https://vimeo.com/user98765432&quote;&gt;R1 Marketing&lt;/a&gt; on &lt;a href=&quote;https://vimeo.com&quote;&gt;Vimeo&lt;/a&gt;.&lt;/p&gt;</textarea>                            
                        </li>
                        <li>
                            You only need to copy the <strong>&lt;<i>iframe</i>&gt;</strong> portion:<br>                            
                            <textarea disabled=\'true\' style=\'border: none;background-color:white;width:100%;font-size:0.75em;\'>&lt;iframe src=&quote;https://player.vimeo.com/video/1233456789&quote; width=&quote;640&quote; height=&quote;360&quote; frameborder=&quote;0&quote; allow=&quote;autoplay; fullscreen&quote; allowfullscreen&gt;&lt;/iframe&gt;</textarea>                            
                        </li>                    
                    </ol>
                <li>Past this code to exabis E-portfolio textarea field.</li>
            </ol>
            ';

// === Privacy wordings
$string['privacy:metadata:block_exaportuser'] = 'user\'s data from exabis e-portfolio';
$string['privacy:metadata:block_exaportuser:user_id'] = 'user id';
$string['privacy:metadata:block_exaportuser:description'] = 'description';
$string['privacy:metadata:block_exaportuser:view_items_layout'] = 'user id';
$string['privacy:metadata:block_exaportcate'] = 'user\'s categories';
$string['privacy:metadata:block_exaportcate:pid'] = 'parent category id';
$string['privacy:metadata:block_exaportcate:userid'] = 'user id';
$string['privacy:metadata:block_exaportcate:name'] = 'title';
$string['privacy:metadata:block_exaportcate:timemodified'] = 'last modified';
$string['privacy:metadata:block_exaportcate:courseid'] = 'course id';
$string['privacy:metadata:block_exaportcate:description'] = 'description';
$string['privacy:metadata:block_exaportcate:subjid'] = 'related subject id';
$string['privacy:metadata:block_exaportcate:topicid'] = 'related topic id';
$string['privacy:metadata:block_exaportcate:source'] = 'source';
$string['privacy:metadata:block_exaportcate:sourceid'] = 'source id';
$string['privacy:metadata:block_exaportcate:parent_ids'] = 'list of parent ids';
$string['privacy:metadata:block_exaportcate:parent_titles'] = 'list of parent titles';
$string['privacy:metadata:block_exaportcate:stid'] = 'schooltype id';
$string['privacy:metadata:block_exaportcate:sourcemod'] = 'sourcemod';
$string['privacy:metadata:block_exaportcate:name_short'] = 'short title';
$string['privacy:metadata:block_exaportcate:shareall'] = 'shared for all? 0 - did not share; 1 - shared for all; 2 - shared for groups';
$string['privacy:metadata:block_exaportcate:internshare'] = 'internal share?';
$string['privacy:metadata:block_exaportcate:structure_shareall'] = 'shared as structure? : 0 - did not share; 1 - shared for all; 2 - shared for groups';
$string['privacy:metadata:block_exaportcate:structure_share'] = 'shared as structure? look also \'structure_shareall\'';
$string['privacy:metadata:block_exaportitem'] = 'user\'s artifact';
$string['privacy:metadata:block_exaportitem:userid'] = 'artifact\'s owner';
$string['privacy:metadata:block_exaportitem:type'] = 'type of artifact';
$string['privacy:metadata:block_exaportitem:categoryid'] = 'category id';
$string['privacy:metadata:block_exaportitem:name'] = 'name';
$string['privacy:metadata:block_exaportitem:url'] = 'url';
$string['privacy:metadata:block_exaportitem:intro'] = 'intro';
$string['privacy:metadata:block_exaportitem:timemodified'] = 'last modified time';
$string['privacy:metadata:block_exaportitem:courseid'] = 'course id';
$string['privacy:metadata:block_exaportitem:shareall'] = 'shared for all?';
$string['privacy:metadata:block_exaportitem:externaccess'] = 'external access?';
$string['privacy:metadata:block_exaportitem:externcomment'] = 'comment for externals';
$string['privacy:metadata:block_exaportitem:fileurl'] = 'url to file';
$string['privacy:metadata:block_exaportitem:exampid'] = 'related example id';
$string['privacy:metadata:block_exaportitem:langid'] = 'language id';
$string['privacy:metadata:block_exaportitem:source'] = 'source';
$string['privacy:metadata:block_exaportitem:sourceid'] = 'source id';
$string['privacy:metadata:block_exaportitem:iseditable'] = 'is editable?';
$string['privacy:metadata:block_exaportitem:example_url'] = 'example_url';
$string['privacy:metadata:block_exaportitem:parentid'] = 'parent id';
$string['privacy:metadata:block_exaportitemcomm'] = 'comments for artifacts';
$string['privacy:metadata:block_exaportitemcomm:itemid'] = 'id of artifact';
$string['privacy:metadata:block_exaportitemcomm:userid'] = 'author of comment';
$string['privacy:metadata:block_exaportitemcomm:entry'] = 'comment';
$string['privacy:metadata:block_exaportitemcomm:timemodified'] = 'last modified';
$string['privacy:metadata:block_exaportview'] = 'comments for artifacts';
$string['privacy:metadata:block_exaportview:userid'] = 'owner of view';
$string['privacy:metadata:block_exaportview:name'] = 'name';
$string['privacy:metadata:block_exaportview:description'] = 'description';
$string['privacy:metadata:block_exaportview:timemodified'] = 'last modified';
$string['privacy:metadata:block_exaportview:shareall'] = 'shared for all?';
$string['privacy:metadata:block_exaportview:externaccess'] = 'external access?';
$string['privacy:metadata:block_exaportview:externcomment'] = 'comment from external?';
$string['privacy:metadata:block_exaportview:langid'] = 'language id';
$string['privacy:metadata:block_exaportview:layout'] = 'layout of the view';
$string['privacy:metadata:block_exaportview:sharedemails'] = 'shared emails list';
$string['privacy:metadata:block_exaportview:autofill_artefacts'] = 'enabled autofill by artifacts';
$string['privacy:metadata:block_exaportresume'] = 'resume data';
$string['privacy:metadata:block_exaportresume:user_id'] = 'resume owner';
$string['privacy:metadata:block_exaportresume:courseid'] = 'course id';
$string['privacy:metadata:block_exaportresume:cover'] = 'cover content';
$string['privacy:metadata:block_exaportresume:interests'] = 'interests';
$string['privacy:metadata:block_exaportresume:goalspersonal'] = 'personal goals';
$string['privacy:metadata:block_exaportresume:goalsacademic'] = 'academic goals';
$string['privacy:metadata:block_exaportresume:goalscareers'] = 'careers goals';
$string['privacy:metadata:block_exaportresume:skillspersonal'] = 'personal skills';
$string['privacy:metadata:block_exaportresume:skillsacademic'] = 'academic skills';
$string['privacy:metadata:block_exaportresume:skillscareers'] = 'careers skills';
$string['privacy:metadata:core_files'] = 'Exabis ePortfolio stores files which have been uploaded by the user to form part of artifacts, resume entries and comments.';
