define("tool_dynamic_cohorts/condition_form",["exports","core/ajax","core/templates","core/fragment","core/modal_events","core/modal_factory","core/notification","core/str"],(function(_exports,_ajax,_templates,_fragment,_modal_events,_modal_factory,_notification,_str){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Condition modal form.
   *
   * @module     tool_dynamic_cohorts/condition_form
   * @copyright  2024 Catalyst IT
   * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   * */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.init=void 0,_ajax=_interopRequireDefault(_ajax),_templates=_interopRequireDefault(_templates),_fragment=_interopRequireDefault(_fragment),_modal_events=_interopRequireDefault(_modal_events),_modal_factory=_interopRequireDefault(_modal_factory),_notification=_interopRequireDefault(_notification);const SELECTORS_ADD_CONDITION_BUTTON="#id_conditionmodalbutton",SELECTORS_SELECT_CONDITION="#id_condition",SELECTORS_CONDITIONS_LIST="#conditions",SELECTORS_RULE_FORM_CONDITIONS_JSON="#id_conditionjson",SELECTORS_RULE_FORM_IS_CONDITIONS_CHANGED="#id_isconditionschanged",SELECTORS_CONDITIONS_NOT_SAVED_WARNING="#tool-dynamic-cohorts-not-saved",SELECTORS_CONDITION_EDIT_ACTION="tool-dynamic-cohorts-condition-edit",SELECTORS_CONDITION_DELETE_ACTION="tool-dynamic-cohorts-condition-delete",SELECTORS_CONDITIONS="tool-dynamic-cohorts-conditions",getModalFormBody=(className,submittedData,defaults)=>{void 0===defaults&&(defaults="");const params={classname:className,jsonformdata:JSON.stringify(submittedData),defaults:JSON.stringify(defaults)};return _fragment.default.loadFragment("tool_dynamic_cohorts","condition_form",1,params)},displayModalForm=(className,defaults)=>{void 0===defaults&&(defaults=""),_modal_factory.default.create({type:_modal_factory.default.types.SAVE_CANCEL,title:(0,_str.get_string)("conditionformtitle","tool_dynamic_cohorts"),body:getModalFormBody(className,"",defaults),large:!0}).then((function(modal){modal.getRoot().on(_modal_events.default.save,(function(e){e.preventDefault(),modal.getRoot().find("form").submit()})),modal.getRoot().on(_modal_events.default.hidden,(function(){modal.destroy()})),modal.getRoot().on("submit","form",(function(e){e.preventDefault(),submitModalFormAjax(className,modal)})),modal.show()}))},submitModalFormAjax=(className,modal)=>{const changeEvent=document.createEvent("HTMLEvents");changeEvent.initEvent("change",!0,!0),modal.getRoot().find(":input").each((function(index,element){element.dispatchEvent(changeEvent)}));const invalid=modal.getRoot().find('[aria-invalid="true"]');if(invalid.length)invalid.first().focus();else{const submittedData=modal.getRoot().find("form").serialize();_ajax.default.call([{methodname:"tool_dynamic_cohorts_submit_condition_form",args:{classname:className,jsonformdata:JSON.stringify(submittedData)},done:function(response){updateCondition(response),renderConditions(getConditions()),modal.destroy()},fail:function(){modal.setBody(getModalFormBody(className,submittedData,""))}}])}},updateCondition=data=>{let condition={...data},conditions=getConditions();condition.sortorder>=0?conditions[condition.sortorder]=condition:(conditions.push(condition),condition.sortorder=conditions.length-1),saveConditionsToRuleForm(conditions)},getConditions=()=>{let conditions=[];const conditionsjson=document.querySelector(SELECTORS_RULE_FORM_CONDITIONS_JSON).value;return""!==conditionsjson&&(conditions=JSON.parse(conditionsjson)),conditions},saveConditionsToRuleForm=conditions=>{document.querySelector(SELECTORS_RULE_FORM_CONDITIONS_JSON).setAttribute("value",JSON.stringify(conditions)),document.querySelector(SELECTORS_RULE_FORM_IS_CONDITIONS_CHANGED).setAttribute("value",1)},renderConditions=conditions=>{_templates.default.render("tool_dynamic_cohorts/conditions",{conditions:conditions}).then((function(html){document.querySelector(SELECTORS_CONDITIONS_LIST).innerHTML=html,applyConditionActions(),document.querySelector(SELECTORS_CONDITIONS_NOT_SAVED_WARNING).classList.remove("hidden")})).fail((function(){_notification.default.exception({message:"Error updating conditions"})}))},applyConditionActions=()=>{document.getElementsByClassName(SELECTORS_CONDITIONS)[0].addEventListener("click",(event=>{let element="SPAN"===event.target.tagName?event.target:event.target.parentNode;if(element.className===SELECTORS_CONDITION_DELETE_ACTION&&_notification.default.confirm((0,_str.get_string)("confirm","moodle"),(0,_str.get_string)("delete_confirm_condition","tool_dynamic_cohorts"),(0,_str.get_string)("yes","moodle"),(0,_str.get_string)("no","moodle"),(function(){let sortorder=element.dataset.sortorder,conditions=getConditions().filter((c=>c.sortorder!=sortorder)).map(((condition,index)=>({...condition,sortorder:index})));saveConditionsToRuleForm(conditions),renderConditions(conditions)})),element.className===SELECTORS_CONDITION_EDIT_ACTION){let sortorder=element.dataset.sortorder,condition=getConditions()[sortorder];displayModalForm(condition.classname,condition)}}))};_exports.init=()=>{const addButton=document.querySelector(SELECTORS_ADD_CONDITION_BUTTON),conditionSelect=document.querySelector(SELECTORS_SELECT_CONDITION);addButton.addEventListener("click",(e=>{e.preventDefault();const className=conditionSelect.value;""!==className&&displayModalForm(className,"")})),applyConditionActions()}}));

//# sourceMappingURL=condition_form.min.js.map