<?php
$browserLocale = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 2);
$defaultLocale = config("minesec.locales_keys.en");
app()->setLocale($browserLocale ?? $defaultLocale);
?>
<!doctype html>
<html lang="en">
<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!--favicon-->
    <link rel="icon" href="{{asset('assets/images/favicon.png')}}" type="image/png" />
    @includeIf('auth.partials.css')
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">
    <title>@yield('title')</title>
</head>

<body class="bg-login">
<!--wrapper-->
@yield('content')
<!--end wrapper-->
@includeIf('auth.partials.js')
<script>
    $(document).ready(function () {
        $("#show_hide_password a").on('click', function (event) {
            event.preventDefault();
            if ($('#show_hide_password input').attr("type") == "text") {
                $('#show_hide_password input').attr('type', 'password');
                $('#show_hide_password i').addClass("bx-hide");
                $('#show_hide_password i').removeClass("bx-show");
            } else if ($('#show_hide_password input').attr("type") == "password") {
                $('#show_hide_password input').attr('type', 'text');
                $('#show_hide_password i').removeClass("bx-hide");
                $('#show_hide_password i').addClass("bx-show");
            }
        });
    });
</script>
</body>
</html>
