@extends("layouts.admin.master")
@section('title', sprintf('%s - %s', __('messages.edit_sub_education_type'), __(config('app.name'))))

@section("style")
    <link href="{{asset('assets/plugins/datatable/css/dataTables.bootstrap5.min.css')}}" rel="stylesheet"/>
@endsection

@section("wrapper")
    <div class="page-wrapper">
        <div class="page-content">

        @include("admin.response.global")

            <!--breadcrumb-->
            <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
                <div class="breadcrumb-title pe-3">{{__("messages.edit_sub_education_type")}}</div>
            </div>
            <!--end breadcrumb-->

            <div class="container">
                <div class="main-body">
                    <!-- start row -->
                    <div class="row">

                        <div class="col-lg-4">
                            <div class="card">
                                <div class="card-body">
                                    <div class="p-4 border rounded">
                                        <form class="row g-3 needs-validation" novalidate action="{{route("sub-education-type.update")}}" method="POST">
                                            @csrf
                                            <input type="hidden" name="id" value="{{ $subEducationType->{"id"} }}"/>

                                            <div class="col-md-12">
                                                <label for="validationCustom03"
                                                       class="form-label">{{__("messages.sub_education_type")}}</label>
                                                <input type="text" value="{{ $subEducationType->{"designation"} }}"
                                                       name="designation" class="form-control" id="validationCustom03"
                                                       required>
                                                <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                            </div>

                                            <div>
                                                <h6 class="mb-0">{{__("messages.specialties")}}</h6>
                                                <div class="card-body">
                                                    @foreach($specialties as $specialty)
                                                        <div class="form-check">
                                                            <label class="form-check-label" for="flexCheckChecked">
                                                                <input class="form-check-input" type="checkbox" id="flexCheckChecked" name="specialtyIds[]"  value="<?php echo $specialty->{"id"} ?>"
                                                                @foreach($subEducationType->{"specialties"} as $selectedSpecialties)
                                                                    {{ ($selectedSpecialties->{"id"} == $specialty->{"id"} ? 'checked' : '') }}
                                                                    @endforeach
                                                                > <?php echo $specialty->{"designation"} ?> </label>
                                                        </div>
                                                    @endforeach
                                                </div>
                                            </div>

                                            <div class="col-12">
                                                <button class="btn btn-primary" style="float: right" type="submit">{{__("messages.save")}}</button>
                                            </div>

                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-8">
                            <div class="card">
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table id="example" class="table table-striped table-bordered"
                                               style="width:100%">
                                            <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>{{__("messages.education_type")}}</th>
                                                <th>{{__("messages.specialties")}}</th>
                                                <th>{{__("messages.action")}}</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            @foreach($subEducationTypes as $subEducationType)
                                                <tr>
                                                    <td><?php echo $subEducationType->{"id"} ?></td>
                                                    <td><?php echo $subEducationType->{"designation"} ?></td>
                                                    <td>
                                                        @foreach($subEducationType->{"specialties"} as $specialty)
                                                            <?php   echo "<div>" . $specialty->{"designation"} . "</div>" ?>
                                                        @endforeach
                                                    </td>
                                                    <td>
                                                        <div class="d-flex order-actions">
                                                            <a href="{{route("sub-education-type.edit", $subEducationType->{"id"}) }}" class="bx bxs-pencil" title="{{__("messages.edit")}}"></a>
                                                            <a href="#" class="bx bxs-trash ms-3 show-delete-modal"  data-sub_education_type_id="{{$subEducationType->{"id"} }}" data-sub_education_type_name="{{$subEducationType->{"designation"} }}"  title="{{__("messages.delete")}}"></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                            @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                    <!--end row-->
                </div>
            </div>

       @include("admin.sub_education_type.delete_modal")

        </div>
    </div>
@endsection

@section("script")
    <script>
        $(document).ready(function() {
            let currentSubEducationTypeId = null;
            let deleteModal = $('#deleteModal');

            $(document).on('click','.show-delete-modal',function(e) {
                currentSubEducationTypeId = $(this).data('sub_education_type_id');
                let sub_education_type_name = $(this).data('sub_education_type_name');
                $("#sub_education_type_name").html(sub_education_type_name);

                $('#deleteModal').modal('show');
            });

            deleteModal.find("button.btn-delete-action").on("click", function(event) {
                event.preventDefault();

                if(currentSubEducationTypeId !== null) {
                    $.ajax({
                        url: "{{route("sub-education-type.delete")}}",
                        type: 'POST',
                        dataType: "json",
                        data: {
                            id: currentSubEducationTypeId,
                        },
                        beforeSend: function(){
                            $('#response').empty();
                            $(".spinner").removeClass('d-none');
                            $(".action-buttons-wrapper").addClass('d-none');
                        },
                        success: function (data) {
                            if(data.error) {
                                $(".btn-cancel-action").prop("enabled", true);
                                $(".btn-delete-action").prop("enabled", true);
                                $(".spinner").addClass('d-none');
                                $(".action-buttons-wrapper").removeClass('d-none');
                                $('#response').html('<span class="text-danger"><b>'+data.error+'</b></span>');
                            }

                            if(data.success) {
                                $(".btn-cancel-action").prop("disabled", true);
                                $(".btn-delete-action").prop("disabled", true);
                                $(".spinner").addClass('d-none');
                                $(".action-buttons-wrapper").removeClass('d-none');
                                $('#response').html('<span class="text-success"><b>'+data.success+'</b></span>');
                                window.setTimeout(function(){
                                    window.location.href = "{{route("sub-education-type.index")}}";
                                },2500)
                            }
                        },
                        error: function () {
                            $(".btn-cancel-action").prop("enabled", true);
                            $(".btn-delete-action").prop("enabled", true);
                            $(".spinner").addClass('d-none');
                            $(".action-buttons-wrapper").removeClass('d-none');
                            alert("<?php echo __("error.generic_error") ?>");
                        }
                    });
                }
            });

        });
    </script>

    <script>
        // Example starter JavaScript for disabling form submissions if there are invalid fields
        (function () {
            'use strict'

            // Fetch all the forms we want to apply custom Bootstrap validation styles to
            var forms = document.querySelectorAll('.needs-validation')

            // Loop over them and prevent submission
            Array.prototype.slice.call(forms)
                .forEach(function (form) {
                    form.addEventListener('submit', function (event) {
                        if (!form.checkValidity()) {
                            event.preventDefault()
                            event.stopPropagation()
                        }
                        form.classList.add('was-validated')
                    }, false)
                })
        })()
    </script>

    <script src="{{asset('assets/plugins/datatable/js/jquery.dataTables.min.js')}}"></script>
    <script src="{{asset('assets/plugins/datatable/js/dataTables.bootstrap5.min.js')}}"></script>
    <script>
        $(document).ready(function () {
            $('#example').DataTable();
        });
    </script>
@endsection
