@extends("layouts.admin.master")
@section('title', sprintf('%s - %s', __('messages.edit_revision'), __(config('app.name'))))

@section("style")
    <link href="{{asset('assets/plugins/datatable/css/dataTables.bootstrap5.min.css')}}" rel="stylesheet"/>
    <link href="{{asset('assets/plugins/select2/css/select2.min.css')}}" rel="stylesheet"/>
    <link href="{{asset('assets/plugins/select2/css/select2-bootstrap4.css')}}" rel="stylesheet"/>
@endsection

@section("wrapper")
    <div class="page-wrapper">
        <div class="page-content">

        @include("admin.response.global")

        <!--breadcrumb-->
            <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
                <div class="breadcrumb-title pe-3">{{__("messages.edit_revision")}}</div>
            </div>
            <!--end breadcrumb-->

            <div class="container">
                <div class="main-body">

                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-body">
                                    <div class="p-4 border rounded">
                                        <form class="row g-3 needs-validation" novalidate action="{{route("revision.update")}}" method="POST">
                                            @csrf
                                            <input type="hidden" value="{{$revision->{"id"} }}" id="revision_id"  name="revision_id">
                                            <div class="col-xl-4 col-md-4">
                                                <label for="sub_system" class="form-label">{{__("messages.sub_systems")}}</label>
                                                <select class="form-select" id="sub_system" name="sub_system" required>
                                                    <option value="">{{__("messages.select")}}</option>
                                                    @foreach($subSystems as $subSystem)
                                                        <option value="{{$subSystem->{"id"} }}"
                                                        @if($subSystem->{'id'} == $revision->{"sub_system_id"})
                                                            {{"selected"}}
                                                            @endif
                                                        >{{$subSystem->{"designation"} }}</option>
                                                    @endforeach
                                                </select>
                                                <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                            </div>

                                            <div class="col-xl-4 col-md-4">
                                                <label for="exam" class="form-label">{{__("messages.exam")}}</label>
                                                <select class="form-select" id="exam" name="exam" required>
                                                    <option value="">{{__("messages.select")}}</option>
                                                    @foreach($xamTypes as $key => $value)
                                                        <option value="{{$key }}"
                                                        @if($key == $revision->{"exam"})
                                                            {{"selected"}}
                                                            @endif
                                                        >{{$value }}</option>
                                                    @endforeach
                                                </select>
                                                <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                            </div>

                                            <div class="col-xl-4 col-md-4">
                                                <label for="subject_id" class="form-label">{{__("messages.subject")}}</label>
                                                {{-- <div class="input-group"><button class="btn btn-outline-secondary" type="button"><i class='bx bx-search'></i></button>--}}
                                                <select class="form-select" id="subject_id" name="subject_id" required>
                                                </select>
                                                <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                            </div>

                                            <div class="col-xl-4 col-md-4">
                                                <label for="validationCustom03" class="form-label">{{__("messages.topic")}}</label>
                                                <input type="text" value="{{ $revision->{'topic'} }}" id="topic" name="topic" class="form-control">
                                            </div>

                                            <div class="col-xl-4 col-md-4">
                                                <label class="form-label">{{__("messages.link")}}</label>
                                                <input type="url" value="{{ $revision->{'link'} }}" name="link" class="form-control" id="link" required>
                                                <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                            </div>

                                            <div class="col-xl-4 col-md-4">
                                                <label for="studio" class="form-label">{{__("messages.studio")}}</label>
                                                <select class="form-select" id="studio" name="studio" required>
                                                    <option value="">{{__("messages.select")}}</option>
                                                    @foreach($studios as $key => $value)
                                                        <option value="{{$key }}"
                                                        @if($key == $revision->{"studio"})
                                                            {{"selected"}}
                                                            @endif
                                                        >{{$value }}</option>
                                                    @endforeach
                                                </select>
                                                <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                            </div>

                                            <div class="col-xl-4 col-md-4">
                                                <label class="form-label">{{__("messages.start_time")}}</label>
                                                <input type="time" value="{{\Carbon\Carbon::parse($revision->{"start_time"})->format("H:i") }}" name="start_time" class="form-control" id="start_time" required>
                                                <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                            </div>

                                            <div class="col-xl-4 col-md-4">
                                                <label class="form-label">{{__("messages.end_time")}}</label>
                                                <input type="time" value="{{\Carbon\Carbon::parse($revision->{"end_time"})->format("H:i") }}" name="end_time" class="form-control" id="end_time" required>
                                                <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                            </div>

                                            <div class="col-xl-4 col-md-4">
                                                <label class="form-label">{{__("messages.date")}}</label>
                                                <input type="date" value="{{$revision->{"date"} }}" name="date" id="date" class="form-control" required>
                                                <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                            </div>

                                            <div class="col-12">
                                                <button class="btn btn-primary" style="float: right" type="submit">{{__("messages.save")}}</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table id="example" class="table table-striped table-bordered"
                                               style="width:100%">
                                            <thead>
                                            <tr>
                                                <th>{{__("messages.sub_systems")}}</th>
                                                <th>{{__("messages.subject")}}</th>
                                                <th>{{__("messages.link")}}</th>
                                                <th>{{__("messages.studio")}}</th>
                                                <th>{{__("messages.start_time")}}</th>
                                                <th>{{__("messages.end_time")}}</th>
                                                <th>{{__("messages.date")}}</th>
                                                <th>{{__("messages.action")}}</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            @foreach($revisions as $schedule)
                                                <?php
                                                $CurrentDateTime = \Illuminate\Support\Carbon::now();
                                                $CarbonEndTime = \Carbon\Carbon::parse($schedule->{"end_time"});
                                                ?>
                                                <tr>
                                                    <td>{{$schedule->{"subSystem"}->{"designation"} }}</td>
                                                    <td>{{$schedule->{"subject"}->{"designation"}." (". $schedule->{"exam"}.")" }}</td>
                                                    @if($CurrentDateTime->gt($CarbonEndTime))
                                                        <td style="width: 8px"><span class="badge bg-gradient-bloody text-white shadow-sm w-100">{{__("messages.closed")}}</span></td>
                                                    @else
                                                        <td><a href="{{$schedule->{"link"} }}" target="_blank"><span class="badge bg-gradient-quepal text-white shadow-sm w-100">{{__("messages.join")}}</span></a></td>
                                                    @endif
                                                    <td>{{$schedule->{"studio"} }}</td>
                                                    <td>{{$schedule->{"start_time"} }}</td>
                                                    <td>{{$schedule->{"end_time"} }}</td>
                                                    <td>{{$schedule->{"date"} }}</td>
                                                    <td>
                                                        <div class="d-flex order-actions">
                                                            <a href="{{route("revision.edit", $schedule->{"id"}) }}" class="bx bxs-pencil" title="{{__("messages.edit")}}"></a>
                                                            <a href="#" class="bx bxs-trash ms-3 show-delete-modal" data-revision_id="{{$schedule->{"id"} }}"  data-revision_subject="{{$schedule->{"subject"}->{"designation"}." (". $schedule->{"exam"}.")" }}" title="{{__("messages.delete")}}"></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                            @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>

            @include("admin.revision.delete_modal")

        </div>
    </div>
@endsection

@section("script")
    <script>
        $(document).ready(function () {
            let currentRevisionId = null;
            let deleteModal = $('#deleteModal');

            $(document).on('click', '.show-delete-modal', function (e) {
                currentRevisionId = $(this).data('revision_id');
                let revision_subject = $(this).data('revision_subject');
                $("#revision_subject").html(revision_subject);
                $('#deleteModal').modal('show');
            });

            deleteModal.find("button.btn-delete-action").on("click", function (event) {
                event.preventDefault();
                if (currentRevisionId !== null) {
                    $.ajax({
                        url: "{{route("revision.delete")}}",
                        type: 'POST',
                        dataType: "json",
                        data: {
                            id: currentRevisionId,
                        },
                        beforeSend: function () {
                            $('#response').empty();
                            $(".spinner").removeClass('d-none');
                            $(".action-buttons-wrapper").addClass('d-none');
                        },
                        success: function (data) {
                            if (data.error) {
                                $(".btn-cancel-action").prop("enabled", true);
                                $(".btn-delete-action").prop("enabled", true);
                                $(".spinner").addClass('d-none');
                                $(".action-buttons-wrapper").removeClass('d-none');
                                $('#response').html('<span class="text-danger"><b>' + data.error + '</b></span>');
                            }
                            if (data.success) {
                                $(".btn-cancel-action").prop("disabled", true);
                                $(".btn-delete-action").prop("disabled", true);
                                $(".spinner").addClass('d-none');
                                $(".action-buttons-wrapper").removeClass('d-none');
                                $('#response').html('<span class="text-success"><b>' + data.success + '</b></span>');
                                window.setTimeout(function () {
                                    window.location.href = "{{route("revision.index")}}";
                                }, 2500)
                            }
                        },
                        error: function () {
                            $(".btn-cancel-action").prop("enabled", true);
                            $(".btn-delete-action").prop("enabled", true);
                            $(".spinner").addClass('d-none');
                            $(".action-buttons-wrapper").removeClass('d-none');
                            alert("<?php echo __("error.generic_error") ?>");
                        }
                    });
                }
            });

            const sub_system_id = $('#sub_system').val();
            const subject_id = <?php echo $revision->{"subject_id"} ?>;

            getSubject(sub_system_id, subject_id, 'subject_id')
            function getSubject(sub_system_id, subject_id, select_control) {
                if(sub_system_id !== ""){
                    $('#' + select_control).html("");
                    var div_data = '<option value="">{{__("messages.select")}}</option>';
                    $.ajax({
                        type: "GET",
                        url: "{{ route('subject.get-sub-system-subjects') }}?sub_system_id=" + sub_system_id,
                        success: function(data) {
                            if(data) {
                                $("#subject_id").empty();
                                $.each(data, function(key, value) {
                                    var sel = "";
                                    if (subject_id === value.id) {
                                        sel = "selected";
                                    }
                                    div_data += "<option value=" + value.id + " " + sel + ">" + value.designation + "</option>";
                                });
                            } else  {
                                $("#subject_id").empty();
                            }
                            $('#' + select_control).append(div_data);
                        },
                    });
                }
            }
        });
    </script>

    <script>
        // Example starter JavaScript for disabling form submissions if there are invalid fields
        (function () {
            'use strict'

            // Fetch all the forms we want to apply custom Bootstrap validation styles to
            var forms = document.querySelectorAll('.needs-validation')

            // Loop over them and prevent submission
            Array.prototype.slice.call(forms)
                .forEach(function (form) {
                    form.addEventListener('submit', function (event) {
                        if (!form.checkValidity()) {
                            event.preventDefault()
                            event.stopPropagation()
                        }
                        form.classList.add('was-validated')
                    }, false)
                })
        })()
    </script>
    <script src="{{asset('assets/plugins/datatable/js/jquery.dataTables.min.js')}}"></script>
    <script src="{{asset('assets/plugins/datatable/js/dataTables.bootstrap5.min.js')}}"></script>
    <script src="{{asset('assets/plugins/select2/js/select2.min.js')}}"></script>
    <script>
        $(document).ready(function () {
            $('#example').DataTable();
        });
    </script>
@endsection
