<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('subject_group_classes', function (Blueprint $table) {
            $table->bigIncrements('id');

            $table->bigInteger('subject_group_id')->unsigned();
            $table->foreign('subject_group_id')->references('id')->on('subject_groups')->onUpdate('cascade')->onDelete('cascade');

            $table->bigInteger('sub_system_id')->unsigned();
            $table->foreign('sub_system_id')->references('id')->on('sub_systems')->onUpdate('cascade')->onDelete('cascade');

            $table->bigInteger('education_type_id')->unsigned();
            $table->foreign('education_type_id')->references('id')->on('education_types')->onUpdate('cascade')->onDelete('cascade');

            $table->bigInteger('sub_education_type_id')->unsigned();

            $table->bigInteger('education_type_class_id')->unsigned()->nullable();
            $table->foreign('education_type_class_id')->references('id')->on('education_type_classes')->onUpdate('cascade')->onDelete('cascade');

            $table->bigInteger('specialty_class_id')->unsigned()->nullable();
            $table->foreign('specialty_class_id')->references('id')->on('specialty_classes')->onUpdate('cascade')->onDelete('cascade');

            $table->bigInteger('level_class_id')->unsigned()->nullable();
            $table->foreign('level_class_id')->references('id')->on('level_classes')->onUpdate('cascade')->onDelete('cascade');

            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('subject_group_classes');
    }
};
