<?php

namespace App\Services;

use App\Models\Subject;
use Exception;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

trait SubjectService
{
    /**
     * Add new record
     *
     * @param array $data
     * @return Builder|Model
     */
    public static function store(array $data): Model|Builder
    {
        return Subject::query()->create($data);
    }

    /**
     * Update existing record
     *
     * @param array $data
     * @return mixed
     */
    public function updateService(array $data): mixed
    {
        return tap($this)->update($data);
    }

    /**'
     * Get all subjects
     *
     * @return Builder[]|Collection
     */
    public  static function allSubjects(): Collection|array
    {

        return Subject::query()->get();
    }

    /**
     * FInd subject by id
     *
     * @param $id
     * @return Model|Builder|null
     */
    public static function findById($id): Model|Builder|null
    {
        return Subject::query()->where('id', $id)->first();
    }

    /**
     * Create subject
     *
     * @param string $designation
     * @param string $type
     * @return Builder|Model
     */
    public static function createSubject(string $designation, string $type): Model|Builder
    {
        return self::store([
            "designation" => $designation,
            "type" => $type,
        ]);
    }

    /**
     * Update class with given id
     *
     * @param int $id
     * @param string $designation
     * @param string $type
     * @return int|null
     */
    public static function updateSubject(int $id, string $designation, string $type): ?int
    {
        try {
            $subject = Subject::query()->where('id', $id)->update(['designation' => $designation, 'type' => $type]);
        } catch (Exception $exception) {
            log_debug(exception: $exception, prefix: 'updateSubject::createRegion');
            $subject = null;
        }

        return $subject;
    }

    /**
     * Delete class with given id
     *
     * @param $id
     * @return int|null
     */
    public  static function deleteSubject($id): ?int
    {
        try {
            $subject = Subject::destroy($id);
        } catch (Exception $exception) {
            log_debug(exception: $exception, prefix: 'deleteSubject::createRegion');
            $subject = null;
        }

        return $subject;
    }
}
