<?php

namespace App\RequestRules\Web;

use JetBrains\PhpStorm\ArrayShape;

class SpecialtyRules
{
    /**
     * create rule
     *
     * @return array
     */

    #[ArrayShape(["designation" => "string", "classIds" => "string"])] public static function create(): array
    {
        return  [
            "designation" => "required|max:100",
            "classIds" => "required|array|exists:classes,id",
        ];
    }

    /** Edit rule
     * @param $id
     * @return string[]
     */
    #[ArrayShape(["id" => "string"])] public static function edit($id): array
    {
        return [
            "id" => "required|integer|exists:specialties",
        ];
    }

    /**
     * Update rule
     *
     * @return string[]
     */
    #[ArrayShape(["id" => "string", "designation" => "string", "classIds" => "string"])] public static function update(): array
    {
        return [
            "id" => "required|integer|exists:specialties",
            "designation" => "required|max:100",
            "classIds" => "required|array|exists:classes,id",
        ];
    }

    /**
     *  Delete rule
     *
     * @return string[]
     */
    #[ArrayShape(["id" => "string"])] public static function delete(): array
    {
        return [
            "id" => "required|integer|exists:specialties",
        ];
    }

    /**
     * Get specialty rule
     *
     * @return array
     */
    #[ArrayShape(["sub_education_type_id" => "string"])] public static function getSpecialties(): array
    {
        return [
            "sub_education_type_id" => "required|integer|exists:sub_education_types,id",
        ];
    }
}
