<?php

namespace App\RequestRules\Web;

use JetBrains\PhpStorm\ArrayShape;

class RolePermissionRules
{

    public static function createRole() {

    }

    /**
     * Get all roles
     *
     * @param $id
     * @return string[]
     */
    #[ArrayShape(["id" => "string"])] public static function getPermissions($id): array
    {
        return [
            "id" => "required|numeric|exists:roles,id",
        ];
    }

    /**
     * Create role/permission rules
     *
     * @return string[]
     */
    #[ArrayShape(["role_id" => "string", "permissionIds" => "string"])] public static function assignPermissionsToRoles(): array
    {
        return [
            "role_id" => "required|numeric|exists:roles,id",
            "permissionIds" => "required|array|exists:permissions,id",
        ];
    }
}
