<?php

namespace App\RequestRules\Web;

use JetBrains\PhpStorm\ArrayShape;

class LevelRules
{
    /**
     * create rule
     *
     * @return array
     */

    #[ArrayShape(["designation" => "string", "classIds" => "string"])] public static function create(): array
    {
        return  [
            "designation" => "required|max:50",
            "classIds" => "required|array|exists:classes,id",
        ];
    }

    /** Edit rule
     * @param $id
     * @return string[]
     */
    #[ArrayShape(["id" => "string"])] public static function edit($id): array
    {
        return [
            "id" => "required|integer|exists:levels",
        ];
    }

    /**
     * Update rule
     *
     * @return string[]
     */
    #[ArrayShape(["id" => "string", "designation" => "string", "classIds" => "string"])] public static function update(): array
    {
        return [
            "id" => "required|integer|exists:levels",
            "designation" => "required|max:50",
            "classIds" => "required|array|exists:classes,id",
        ];
    }

    /**
     *  Delete rule
     *
     * @return string[]
     */
    #[ArrayShape(["id" => "string"])] public static function delete(): array
    {
        return [
            "id" => "required|integer|exists:levels",
        ];
    }

    /**
     * Get Level rule
     *
     * @return array
     */
    #[ArrayShape(["education_type_id" => "string"])] public static function getLevels(): array
    {
        return [
            "education_type_id" => "required|integer|exists:education_types,id",
        ];
    }
}
