<?php

namespace App\RequestRules\Web;

use JetBrains\PhpStorm\ArrayShape;

class LessonRules
{
    /**
     * Create general education lesson rule
     *
     * @return array
     */
    #[ArrayShape(['lesson_title' => "string", 'lesson_description' => "string", 'lesson_video' => "string", 'sub_system_id' => "string", 'education_type_id' => "string", 'classIds' => "string", 'subjectIds' => "string", 'term_id' => "string"])] public static function createGeneralEducationLesson(): array
    {
//        $imageExtensions = config('vuix.constants.image_extensions');
//        $imageMaxSize = config('vuix.constants.max_file_size');

        return [
            'lesson_title' => 'required|string|max:255',
            'lesson_description' => 'required|string|max:255',
            'lesson_video' => 'required|file|mimetypes:video/mp4',
            "sub_system_id" => "required|integer|exists:sub_systems,id",
            "classIds" => "required|array|exists:classes,id",
            "subjectIds" => "required|array|exists:subjects,id",
            "term_id" => "required|integer|exists:terms,id",
//            'lesson_video' => ['required', 'file', 'mimes:' . $imageExtensions, 'max:' . $imageMaxSize],
        ];
    }

    /**
     * Create technical education lesson rule
     *
     * @return array
     */
    #[ArrayShape(['lesson_title' => "string", 'lesson_description' => "string", 'lesson_video' => "string", 'sub_system_id' => "string", 'education_type_id' => "string", 'sub_education_type_id' => "string",  'specialty_id' => "string", 'specialtyClassIds' => "string", 'subjectIds' => "string", 'term_id' => "string"])] public static function createTechnicalEducationLesson(): array
    {
        return [
            'lesson_title' => 'required|string|max:255',
            'lesson_description' => 'required|string|max:255',
            'lesson_video' => 'required|file|mimetypes:video/mp4',
            "sub_system_id" => "required|integer|exists:sub_systems,id",
            "sub_education_type_id" => "required|integer|exists:sub_education_types,id",
            "specialty_id" => "required|integer|exists:specialties,id",
            "specialtyClassIds" => "required|array|exists:classes,id",
            "subjectIds" => "required|array|exists:subjects,id",
            "term_id" => "required|integer|exists:terms,id",
        ];
    }

    /**
     * Create technical education lesson rule
     *
     * @return array
     */
    #[ArrayShape(['lesson_title' => "string", 'lesson_description' => "string", 'lesson_video' => "string", 'sub_system_id' => "string", 'education_type_id' => "string", 'level_id' => "string", 'leveClassIds' => "string", 'subjectIds' => "string", 'term_id' => "string"])] public static function createTeacherTrainingLesson(): array
    {
        return [
            'lesson_title' => 'required|string|max:255',
            'lesson_description' => 'required|string|max:255',
            'lesson_video' => 'required|file|mimetypes:video/mp4',
            "sub_system_id" => "required|integer|exists:sub_systems,id",
            "level_id" => "required|integer|exists:levels,id",
            "leveClassIds" => "required|array|exists:classes,id",
            "subjectIds" => "required|array|exists:subjects,id",
            "term_id" => "required|integer|exists:terms,id",
        ];
    }

    /**
     * Delete
     *
     * @return string[]
     */
    #[ArrayShape(["id" => "string"])] public static function delete($id): array
    {
        return [
            "id" => "required|integer|exists:lessons",
        ];
    }

}
