<?php

namespace App\RequestRules\Web;

class HomeRules
{

    /**
     * General education program rules
     *
     * @return string[]
     */
    public static function createGenEducProgramCoverage(): array
    {
        return [
            "sub_system_id" => "required|integer|exists:sub_systems,id",
            "subject_id" => "required|integer|exists:subjects,id",
            "class_id" => "required|integer|exists:classes,id",

            "school_id" => "required|integer|exists:schools,id",

            "number_of_lessons_programmed" => "required|string|max:80",
            "number_of_lessons_done" => "required|string|max:80",
            "percentage_number_of_lessons_done" => "required|string|max:80",
            "comment_number_of_lessons_done" => "required|string|max:600",
            "number_of_teaching_hours" => "required|string|max:80",
            "number_of_hours_taught" => "required|string|max:80",
            "percentage_number_of_hours_taught" => "required|string|max:80",
            "comment_number_of_hours_taught" => "required|string|max:80",
            "number_of_lessons_to_digitalised" => "required|string|max:80",
            "number_of_lessons_digitalised" => "required|string|max:80",
            "percentage_number_of_lessons_digitalised" => "required|string|max:80",
            "comment_number_of_lessons_digitalised" => "required|string|max:80",
            "ots_effective" => "required|string|max:80",
            "number_of_ots_participants" => "required|string|max:80",
            "number_of_seminars_organised" => "required|string|max:80",
            "number_of_seminar_participants" => "required|string|max:80",


            "titles_of_digitalised_lessons" => "required|array",
            "digitisation_types" => "required|array",
            "digitisation_tools_used" => "required|array",
            "measures_taken_to_ensure_program_coverage" => "required|array",
            "seminar_topics_discussed" => "required|array",
        ];
    }

    /**
     * Technical education rules
     *
     * @return string[]
     */
    public static function createTechEducProgramCoverage(): array
    {
        return [
            "sub_system_id" => "required|integer|exists:sub_systems,id",
            "sub_education_type_id" => "required|integer|exists:sub_education_types,id",
            "specialty_id" => "required|integer|exists:specialties,id",
            "subject_id" => "required|integer|exists:subjects,id",
            "specialty_class_id" => "required|integer|exists:classes,id",

            "school_id" => "required|integer|exists:schools,id",
            "number_of_lessons_programmed" => "required|string|max:80",
            "number_of_lessons_done" => "required|string|max:80",
            "percentage_number_of_lessons_done" => "required|string|max:80",
            "comment_number_of_lessons_done" => "required|string|max:600",
            "number_of_teaching_hours" => "required|string|max:80",
            "number_of_hours_taught" => "required|string|max:80",
            "percentage_number_of_hours_taught" => "required|string|max:80",
            "comment_number_of_hours_taught" => "required|string|max:80",
            "number_of_lessons_to_digitalised" => "required|string|max:80",
            "number_of_lessons_digitalised" => "required|string|max:80",
            "percentage_number_of_lessons_digitalised" => "required|string|max:80",
            "comment_number_of_lessons_digitalised" => "required|string|max:80",
            "ots_effective" => "required|string|max:80",
            "number_of_ots_participants" => "required|string|max:80",
            "number_of_seminars_organised" => "required|string|max:80",
            "number_of_seminar_participants" => "required|string|max:80",


            "titles_of_digitalised_lessons" => "required|array",
            "digitisation_types" => "required|array",
            "digitisation_tools_used" => "required|array",
            "measures_taken_to_ensure_program_coverage" => "required|array",
            "seminar_topics_discussed" => "required|array",
        ];
    }

    /**
     * Teacher Training program rules
     *
     * @return string[]
     */
    public static function createTeachTrainProgramCoverage(): array
    {
        return [
            "sub_system_id" => "required|integer|exists:sub_systems,id",
            "level_id" => "required|integer|exists:levels,id",
            "subject_id" => "required|integer|exists:subjects,id",
            "level_class_id" => "required|integer|exists:classes,id",

            "school_id" => "required|integer|exists:schools,id",
            "number_of_lessons_programmed" => "required|string|max:80",
            "number_of_lessons_done" => "required|string|max:80",
            "percentage_number_of_lessons_done" => "required|string|max:80",
            "comment_number_of_lessons_done" => "required|string|max:600",
            "number_of_teaching_hours" => "required|string|max:80",
            "number_of_hours_taught" => "required|string|max:80",
            "percentage_number_of_hours_taught" => "required|string|max:80",
            "comment_number_of_hours_taught" => "required|string|max:80",
            "number_of_lessons_to_digitalised" => "required|string|max:80",
            "number_of_lessons_digitalised" => "required|string|max:80",
            "percentage_number_of_lessons_digitalised" => "required|string|max:80",
            "comment_number_of_lessons_digitalised" => "required|string|max:80",
            "ots_effective" => "required|string|max:80",
            "number_of_ots_participants" => "required|string|max:80",
            "number_of_seminars_organised" => "required|string|max:80",
            "number_of_seminar_participants" => "required|string|max:80",


            "titles_of_digitalised_lessons" => "required|array",
            "digitisation_types" => "required|array",
            "digitisation_tools_used" => "required|array",
            "measures_taken_to_ensure_program_coverage" => "required|array",
            "seminar_topics_discussed" => "required|array",
        ];
    }
}
