<?php

namespace App\Models;

use App\Services\SubSystemService;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class SubSystem extends Model
{
    use HasFactory;
    use SoftDeletes;
    use SubSystemService;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'sub_systems';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = ['designation'];

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    protected $dates = ['created_at', 'updated_at', 'deleted_at'];

    /**
     * The "booting" method of the model.
     *
     * @return void
     */
    public static function boot()
    {
        parent::boot();
    }

    /**
     * Relations functions
     */

    /**
     * Education types that belong to sub system
     *
     * @return BelongsToMany
     */
    public function educationTypes(): BelongsToMany
    {
        return $this->belongsToMany(EducationType::class, 'sub_system_education_types', 'sub_system_id', 'education_type_id');
    }

    /**
     * Subjects belonging to sub system
     *
     * @return BelongsToMany
     */
    public  function subjects(): BelongsToMany
    {
        return $this->belongsToMany(Subject::class, 'sub_system_subjects', 'sub_system_id', 'subject_id');
    }
}
