<?php

namespace App\Models;

use App\Services\SpecialtyService;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class Specialty extends Model
{
    use HasFactory;
    use SoftDeletes;
    use SpecialtyService;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'specialties';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = ['designation'];

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    protected $dates = ['created_at', 'updated_at', 'deleted_at'];

    /**
     * The "booting" method of the model.
     *
     * @return void
     */
    public static function boot()
    {
        parent::boot();
    }

    /**
     * Relations functions
     */

    /**
     * Classes that belong to specialty
     *
     * @return BelongsToMany
     */
    public  function classes(): BelongsToMany
    {

        return $this->belongsToMany(Classes::class, 'specialty_classes', 'specialty_id', 'class_id');
    }
}
