<?php

namespace App\Models;

use App\Services\EducationTypeService;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class EducationType extends Model
{
    use HasFactory;
    use EducationTypeService;
    use SoftDeletes;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'education_types';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = ['designation', 'type'];

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    protected $dates = ['created_at', 'updated_at', 'deleted_at'];

    /**
     * The "booting" method of the model.
     *
     * @return void
     */
    public static function boot()
    {
        parent::boot();
    }

    /**
     * Relations functions
     */


    /**
     * CLasses that belong to education type
     *
     * @return BelongsToMany
     */
    public  function classes(): BelongsToMany
    {
        return $this->belongsToMany(Classes::class, 'education_type_classes', 'education_type_id', 'class_id');
    }

    /**
     * Sub education types that belong to education type
     *
     * @return BelongsToMany
     */
    public function subEducation(): BelongsToMany
    {
        return $this->belongsToMany(SubEducationType::class, 'education_type_sub_education_types', 'education_type_id', 'sub_education_type_id');
    }

    /**
     * Get levels that belong to education type
     *
     * @return BelongsToMany
     */
    public function Levels(): BelongsToMany
    {
        return $this->belongsToMany(Level::class, 'education_type_levels', 'education_type_id', 'level_id');
    }
}
