<?php

namespace App\Models;

use App\Services\DigitizationToolService;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class DigitizationTool extends Model
{
    use HasFactory;
    use SoftDeletes;
    use DigitizationToolService;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'digitization_tools';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = ['designation', 'program_coverage_id'];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    protected $dates = ['created_at', 'updated_at', 'deleted_at'];

    /**
     * The "booting" method of the model.
     *
     * @return void
     */
    public static function boot()
    {
        parent::boot();
    }

    /**
     * Relations functions
     */

    /**
     * The divisions that belong to the region.
     */
}
