<?php

namespace App\Http\Controllers\Web\Admin;

use App\Http\Controllers\Controller;
use App\Models\PermissionGroup;
use App\Models\Role;
use App\RequestRules\Web\RolePermissionRules;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\View\Factory;
use Illuminate\Contracts\View\View;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Redirect;

class RolePermissionController extends Controller
{
    /**
     * Get roles index view
     *
     * @return Application|Factory|View
     */
    public function index(): View|Factory|Application
    {
        $roles = Role::allRoles();

        return view("admin.settings.role_permission.index", compact('roles'));
    }

    /**
     * Get permissions view
     *
     * @param Request $request
     * @return Application|Factory|View
     */
    public function rolePermission(Request $request): View|Factory|Application
    {
        $request->validate(RolePermissionRules::getPermissions($request->merge(["id" => $request->route("id")])));

        $role = Role::findById($request->get("id"));
        $permissionGroups = PermissionGroup::allPermissionGroups();
        $roleHasPermissions = $role->{"roleHasPermission"};

        return view("admin.settings.role_permission.permission", compact("permissionGroups","role", "roleHasPermissions"));
    }

    /**
     * Assign permissions to role
     * @param Request $request
     * @return RedirectResponse
     */
    public function assign(Request $request): RedirectResponse
    {
        $request->validate(RolePermissionRules::assignPermissionsToRoles());

       $data = $request->all();

        $response = Role::assignPermissionsToRole($data);

        if ($response == null) {
            return Redirect::back()->with("error", __("error.generic_error"));
        }

        return Redirect::back()->with("success", __("messages.record_successfully_created"));
    }
}
