
<?php $__env->startSection('title', sprintf('%s - %s', __('messages.subjects'), __(config('app.name')))); ?>

<?php $__env->startSection("style"); ?>
    <link href="<?php echo e(asset('assets/plugins/datatable/css/dataTables.bootstrap5.min.css')); ?>" rel="stylesheet" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection("wrapper"); ?>
    <div class="page-wrapper">
        <div class="page-content">

             <?php echo $__env->make("admin.response.global", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <!--breadcrumb-->
            <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
                <div class="breadcrumb-title pe-3"><?php echo e(__("messages.add_subject")); ?></div>
            </div>
            <!--end breadcrumb-->

            <div class="container">
                <div class="main-body">
                    <!-- start row -->
                    <div class="row">
                        <div class="col-lg-4">
                            <div class="card">
                                <div class="card-body">
                                    <div class="p-4 border rounded">
                                        <form class="row g-3 needs-validation" novalidate action="<?php echo e(route("subject.create")); ?>" method="POST">
                                            <?php echo csrf_field(); ?>
                                            <div class="col-md-12">
                                                <label for="validationCustom03" class="form-label"><?php echo e(__("messages.subject")); ?></label>
                                                <input type="text" value="<?php echo e(old('designation')); ?>" name="designation" class="form-control" id="validationCustom03" required>
                                                <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                            </div>

                                            <div class="card-body">
                                                <div class="form-check form-check-inline">
                                                <input type="radio" class="form-check-input" id="validationFormCheck3" name="type" value="<?php echo e(config('minesec.subject_type.theory')); ?>"  <?php echo e(old('type') == config('minesec.subject_type.theory') ? 'checked' : ''); ?> required>
                                                <label class="form-check-label" for="validationFormCheck3"><?php echo e(__("messages.theory")); ?></label>
                                                <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                            </div>

                                                <div class="form-check form-check-inline">
                                                    <input type="radio" class="form-check-input" id="validationFormCheck3" name="type" value="<?php echo e(config('minesec.subject_type.practical')); ?>"  <?php echo e(old('type') == config('minesec.subject_type.practical') ? 'checked' : ''); ?> required>
                                                    <label class="form-check-label" for="validationFormCheck3"><?php echo e(__("messages.practical")); ?></label>
                                                    <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                                </div>
                                            </div>

                                            <div class="col-12">
                                                <button class="btn btn-primary" style="float: right" type="submit"><?php echo e(__("messages.save")); ?></button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-8">
                            <div class="card">
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table id="example" class="table table-striped table-bordered" style="width:100%">
                                            <thead>
                                            <tr>
                                                <th>#</th>
                                                <th><?php echo e(__("messages.subjects")); ?></th>
                                                <th><?php echo e(__("messages.type")); ?></th>
                                                <th><?php echo e(__("messages.action")); ?></th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <?php $__currentLoopData = $subjects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subject): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo $subject->{"id"} ?></td>
                                                    <td><?php echo $subject->{"designation"} ?></td>
                                                    <td><?php echo $subject->{"type"} ?></td>
                                                    <td>
                                                        <div class="d-flex order-actions">
                                                            <a href="<?php echo e(route("subject.edit", $subject->{"id"})); ?>" class="bx bxs-pencil" title="<?php echo e(__("messages.edit")); ?>"></a>
                                                            <a href="#" class="bx bxs-trash ms-3 show-delete-modal"  data-subject_id="<?php echo e($subject->{"id"}); ?>" data-subject_name="<?php echo e($subject->{"designation"}); ?>"  title="<?php echo e(__("messages.delete")); ?>"></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                    <!--end row-->
                </div>
            </div>

            <?php echo $__env->make("admin.subject.delete_modal", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection("script"); ?>
    <script>
        $(document).ready(function() {
            let currentSubjectId = null;
            let deleteModal = $('#deleteModal');

            $(document).on('click','.show-delete-modal',function(e) {
                currentSubjectId = $(this).data('subject_id');
                let subject_name = $(this).data('subject_name');
                $("#subject_name").html(subject_name);

                $('#deleteModal').modal('show');
            });

            deleteModal.find("button.btn-delete-action").on("click", function(event) {
                event.preventDefault();

                if(currentSubjectId !== null) {
                    $.ajax({
                        url: "<?php echo e(route("subject.delete")); ?>",
                        type: 'POST',
                        dataType: "json",
                        data: {
                            id: currentSubjectId,
                        },
                        beforeSend: function(){
                            $('#response').empty();
                            $(".spinner").removeClass('d-none');
                            $(".action-buttons-wrapper").addClass('d-none');
                        },
                        success: function (data) {
                            if(data.error) {
                                $(".btn-cancel-action").prop("enabled", true);
                                $(".btn-delete-action").prop("enabled", true);
                                $(".spinner").addClass('d-none');
                                $(".action-buttons-wrapper").removeClass('d-none');
                                $('#response').html('<span class="text-danger"><b>'+data.error+'</b></span>');
                            }

                            if(data.success) {
                                $(".btn-cancel-action").prop("disabled", true);
                                $(".btn-delete-action").prop("disabled", true);
                                $(".spinner").addClass('d-none');
                                $(".action-buttons-wrapper").removeClass('d-none');
                                $('#response').html('<span class="text-success"><b>'+data.success+'</b></span>');
                                window.setTimeout(function(){
                                    window.location.href = "<?php echo e(route("subject.index")); ?>";
                                },2500)
                            }
                        },
                        error: function () {
                            $(".btn-cancel-action").prop("enabled", true);
                            $(".btn-delete-action").prop("enabled", true);
                            $(".spinner").addClass('d-none');
                            $(".action-buttons-wrapper").removeClass('d-none');
                            alert("<?php echo __("error.generic_error") ?>");
                        }
                    });
                }
            });

        });
    </script>

    <script>
        // Example starter JavaScript for disabling form submissions if there are invalid fields
        (function () {
            'use strict'

            // Fetch all the forms we want to apply custom Bootstrap validation styles to
            var forms = document.querySelectorAll('.needs-validation')

            // Loop over them and prevent submission
            Array.prototype.slice.call(forms)
                .forEach(function (form) {
                    form.addEventListener('submit', function (event) {
                        if (!form.checkValidity()) {
                            event.preventDefault()
                            event.stopPropagation()
                        }
                        form.classList.add('was-validated')
                    }, false)
                })
        })()
    </script>

    <script src="<?php echo e(asset('assets/plugins/datatable/js/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/datatable/js/dataTables.bootstrap5.min.js')); ?>"></script>
    <script>
        $(document).ready(function() {
            $('#example').DataTable();
        } );
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("layouts.admin.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\minesec-distance-education-web\resources\views/admin/subject/index.blade.php ENDPATH**/ ?>