<?php
$browserLocale = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 2);
$defaultLocale = config("minesec.locales_keys.en");
app()->setLocale($browserLocale ?? $defaultLocale);
?>

<!doctype html>
<html lang="">
<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!--favicon-->
    <link rel="icon" href="<?php echo e(asset('assets/images/favicon.png')); ?>" type="image/png"/>

    <!--plugins-->
    <link href="<?php echo e(asset('assets/plugins/simplebar/css/simplebar.css')); ?>" rel="stylesheet"/>
    <link href="<?php echo e(asset('assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css')); ?>" rel="stylesheet"/>
    <link href="<?php echo e(asset('assets/plugins/metismenu/css/metisMenu.min.css')); ?>" rel="stylesheet"/>

    <!-- loader-->
    <link href="<?php echo e(asset('assets/css/pace.min.css')); ?>" rel="stylesheet"/>
    <script src="<?php echo e(asset('assets/js/pace.min.js')); ?>"></script>

    <!-- Bootstrap CSS -->
    <link href="<?php echo e(asset('assets/css/bootstrap.min.css')); ?>" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">
    <link href="<?php echo e(asset('assets/css/app.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/css/icons.css')); ?>" rel="stylesheet">
    <title><?php echo e(__(config('app.name'))); ?></title>
</head>

<body style="background-color: #F0F0F0">
<!--wrapper-->
<div class="wrapper">
    <?php if ($__env->exists('layouts.default.header')) echo $__env->make('layouts.default.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div style="padding-top: 80px">
        <div class="container">
            <div class="col-xl-12">
                <div class="card">
                    <img src="<?php echo e(asset('assets/images/header_design.png')); ?>" class="img-fluid pull-right" alt="">
                    <div class="card-body">
                        <h4 class="font-weight-bold text-center"><?php echo e(__("messages.sub_system")); ?></h4>

                        <div class="row row-cols-2 row-cols-lg-2 product-grid">
                            <?php $__currentLoopData = $subSystems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subSystem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col">
                                    <div class="card">
                                        <a class="selectSubSystem" href='javascript:void(0);' data-sub_system_id="<?php echo e($subSystem->{"id"}); ?>"><img src="<?php echo e(asset('assets/images/products/01.png')); ?>" class="card-img-top" height="60" width="90" alt="..."></a>
                                        <div class="card-body"><h6 class="card-title text-center"><?php echo e($subSystem->{"designation"}); ?></h6>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>

                        <div id="educationTypeDesignation">
                            <div class="font-weight-bold text-center"><h4><?php echo e(__("messages.education_type")); ?></h4></div>
                            <div class="row row-cols-1 row-cols-lg-3 product-grid educationTypes">
                            </div>
                        </div>


                        <!-- Start general class -->
                        <div id="classInputDesignation">
                            <div class="font-weight-bold text-center"><h4><?php echo e(__("messages.classes")); ?></h4></div>
                            <div class="row row-cols-4 row-cols-lg-4 justify-content-center classInput class_radio_button">
                            </div>
                        </div>
                        <!-- End general class -->


                        <!-- Start Sub Educ, Specialty and Specialty class -->
                        <div id="subEducationTypeDesignation">
                            <h4 class="font-weight-bold text-center"><?php echo e(__("messages.sub_education_type")); ?></h4>
                            <div class="row row-cols-3 row-cols-lg-3 justify-content-center subEducationTypeInput sub_education_type_radio_button">
                            </div>
                        </div>

                        <div id="specialtyDesignation">
                            <h4 class="font-weight-bold text-center"><?php echo e(__("messages.specialties")); ?></h4>
                            <div class="row row-cols-4 row-cols-lg-4 justify-content-center specialtyInput specialty_radio_button">
                            </div>
                        </div>

                        <div id="specialtyClassDesignation">
                            <h4 class="font-weight-bold text-center"><?php echo e(__("messages.classes")); ?></h4>
                            <div class="row row-cols-4 row-cols-lg-4 justify-content-center specialtyInput specialty_class_radio_button">
                            </div>
                        </div>
                        <!-- End Sub Educ, Specialty and Specialty class -->


                        <!-- Start Level & Level Class -->
                        <div id="levelDesignation">
                            <h4 class="font-weight-bold text-center"><?php echo e(__("messages.level")); ?></h4>
                            <div class="row row-cols-3 row-cols-lg-3 justify-content-center levelInput level_radio_button">
                            </div>
                        </div>

                        <div id="levelClassDesignation">
                            <h4 class="font-weight-bold text-center"><?php echo e(__("messages.classes")); ?></h4>
                            <div class="row row-cols-3 row-cols-lg-3 justify-content-center levelClassInput level_class_radio_button">
                            </div>
                        </div>
                        <!-- End Level and Level Class -->

                    </div>
                </div>

                <!-- Start section 2 -->
                <div class="card">
                    <div class="card-body">
                        <h3 class="card-title text-center"><?php echo e(__("messages.most_recent_lessons")); ?></h3>

                        <div class="card-body">
                            <div class="row row-cols-auto float-end">
                                <ul class="px-2 nav nav-pills nav-pills-success mb-2" role="tablist">
                                    <li class="nav-item" role="presentation">
                                        <a class="nav-link active" data-bs-toggle="pill" href="#lessons"
                                           role="tab" aria-selected="true">
                                            <div class="d-flex align-items-center">
                                                <div class="tab-icon"><i class='bx bx-video font-18 me-1'></i>
                                                </div>
                                                <div class="tab-title"><?php echo e(__("messages.lessons")); ?></div>
                                            </div>
                                        </a>
                                    </li>
                                    <li class="nav-item" role="presentation">
                                        <a class="nav-link" data-bs-toggle="pill" href="#revision"
                                           role="tab" aria-selected="false">
                                            <div class="d-flex align-items-center">
                                                <div class="tab-icon"><i class='bx bx-calendar font-18 me-1'></i>
                                                </div>
                                                <div class="tab-title"><?php echo e(__("messages.revision")); ?></div>
                                            </div>
                                        </a>
                                    </li>
                                </ul>
                            </div>

                            <div class="tab-content" id="pills-tabContent">
                                <div class="tab-pane fade show active email-wrapper my-6" id="lessons" role="tabpanel">
                                    <!-- Start subjects list -->
                                    <div class="email-sidebar">
                                        <div class="email-sidebar-header d-grid"><h4 class="font-weight-bold"><?php echo e(__("messages.subjects")); ?></h4>
                                        </div>
                                        <div class="email-sidebar-content">
                                            <div class="email-navigation">
                                                <div class="list-group list-group-flush class_subjects">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- End subjects list -->

                                    <!-- Start lesson view area top bar -->
                                    <div class="email-header d-xl-flex align-items-center">
                                        <div class="d-flex align-items-center">
                                            <div class="email-toggle-btn"><i class='bx bx-menu'></i>
                                            </div>
                                            <div class="btn btn-white">
                                                <input class="form-check-input" type="checkbox">
                                            </div>
                                            <div class="">
                                                <button type="button" class="btn btn-white ms-2"><i
                                                        class='bx bx-refresh me-0'></i>
                                                </button>
                                            </div>
                                            <div class="">
                                                <button type="button" class="btn btn-white ms-2"><i
                                                        class='bx bx-downvote me-0'></i>
                                                </button>
                                            </div>
                                            <div class="d-none d-md-flex">
                                                <button type="button" class="btn btn-white ms-2"><i
                                                        class='bx bx-file me-0'></i>
                                                </button>
                                            </div>
                                            <div class="">
                                                <button type="button" class="btn btn-white ms-2"><i
                                                        class='bx bx-trash me-0'></i>
                                                </button>
                                            </div>
                                        </div>
                                        <div class="flex-grow-1 mx-xl-2 my-2 my-xl-0">
                                            <div class="input-group"><span class="input-group-text bg-transparent"><i
                                                        class="bx bx-search"></i></span>
                                                <input type="text" class="form-control" placeholder="Search mail">
                                            </div>
                                        </div>
                                        <div class="ms-auto d-flex align-items-center">
                                            <button class="btn btn-sm btn-light">1-50 of 8,740</button>
                                            <button class="btn btn-white px-2 ms-2"><i class='bx bx-chevron-left me-0'></i>
                                            </button>
                                            <button class="btn btn-white px-2 ms-2"><i class='bx bx-chevron-right me-0'></i>
                                            </button>
                                        </div>
                                    </div>
                                    <!-- End lesson view top bar -->

                                    <!-- Start lesson View Area -->
                                    <div class="email-content px-4 my-2">
                                        <div class="">
                                            <div class="email-list">
                                                <div
                                                    class="row row-cols-1 row-cols-md-2 row-cols-lg-3 row-cols-xl-3 class_lessons">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- End lesson view area -->
                                </div>
                                <div class="tab-pane fade email-wrapper my-6" id="revision" role="tabpanel">
                                    <div class="card radius-10">
                                        <div class="card-body">
                                            <ul class="nav nav-tabs nav-success" role="tablist">
                                                <li class="nav-item" role="presentation">
                                                    <a class="nav-link active" data-bs-toggle="tab" href="#englishSubSystem" role="tab" aria-selected="true">
                                                        <div class="d-flex align-items-center">
                                                            <div class="tab-icon"><i class='bx bx-book-open font-18 me-1'></i>
                                                            </div>
                                                            <div class="tab-title"><?php echo e(__("messages.english_sub_system")); ?></div>
                                                        </div>
                                                    </a>
                                                </li>
                                                <li class="nav-item" role="presentation">
                                                    <a class="nav-link" data-bs-toggle="tab" href="#frenchSubSystem" role="tab" aria-selected="false">
                                                        <div class="d-flex align-items-center">
                                                            <div class="tab-icon"><i class='bx bx-book-open font-18 me-1'></i>
                                                            </div>
                                                            <div class="tab-title"><?php echo e(__("messages.french_sub_system")); ?></div>
                                                        </div>
                                                    </a>
                                                </li>
                                            </ul>
                                            <?php
                                            $englishSubSystemArray = array();
                                            $frenchSubSystemArray = array();

                                            foreach ($revisions as $revision) {
                                                $CurrentDateTime = \Illuminate\Support\Carbon::now();

                                                if($revision->{"subSystem"}->{"id"} == config("minesec.sub_systems.english_sub_system")){
                                                    $CarbonEndTime = \Carbon\Carbon::parse($revision->{"end_time"});
                                                    $englishSubSystemArray[] = array(
                                                        "subject" => $revision->{"subject"}->{"designation"},
                                                        "exam" => $revision->{"exam"},
                                                        "topic" => $revision->{"topic"},
                                                        "date" => $revision->{"date"},
                                                        "start_time" => $revision->{"start_time"},
                                                        "end_time" => $revision->{"end_time"},
                                                        "studio" => $revision->{"studio"},
                                                        "link" => $revision->{"link"},
                                                        "current_date" => $CurrentDateTime,
                                                        "carbon_end_time" => $CarbonEndTime,
                                                    );
                                                }  else {
                                                    $CarbonEndTime = \Carbon\Carbon::parse($revision->{"end_time"});
                                                    $frenchSubSystemArray[] = array(
                                                        "subject" => $revision->{"subject"}->{"designation"},
                                                        "exam" => $revision->{"exam"},
                                                        "topic" => $revision->{"topic"},
                                                        "date" => $revision->{"date"},
                                                        "start_time" => $revision->{"start_time"},
                                                        "end_time" => $revision->{"end_time"},
                                                        "studio" => $revision->{"studio"},
                                                        "link" => $revision->{"link"},
                                                        "current_date" => $CurrentDateTime,
                                                        "carbon_end_time" => $CarbonEndTime,
                                                    );
                                                }
                                            }
                                            ?>
                                            <div class="tab-content py-3">
                                                <div class="tab-pane fade show active" id="englishSubSystem" role="tabpanel">
                                                    <div class="table-responsive">
                                                        <table class="table align-middle mb-0">
                                                            <thead class="table-light">
                                                            <tr>
                                                                <th><?php echo e(__("messages.exam")); ?></th>
                                                                <th><?php echo e(__("messages.subject")); ?></th>
                                                                <th><?php echo e(__("messages.topic")); ?></th>
                                                                <th><?php echo e(__("messages.date")); ?></th>
                                                                <th><?php echo e(__("messages.start_time")); ?></th>
                                                                <th><?php echo e(__("messages.end_time")); ?></th>
                                                                <th><?php echo e(__("messages.studio")); ?></th>
                                                                <th><?php echo e(__("messages.link")); ?></th>
                                                            </tr>
                                                            </thead>
                                                            <tbody>
                                                            <?php if(sizeof($englishSubSystemArray) != 0): ?>
                                                            <?php $__currentLoopData = $englishSubSystemArray; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $englishSubSystem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <tr>
                                                                        <td><?php echo e($englishSubSystem["exam"]); ?></td>
                                                                        <td><?php echo e($englishSubSystem["subject"]); ?></td>
                                                                        <td><?php echo e($englishSubSystem["topic"]); ?></td>
                                                                        <td><?php echo e($englishSubSystem["date"]); ?></td>
                                                                        <td><?php echo e($englishSubSystem["start_time"]); ?></td>
                                                                        <td><?php echo e($englishSubSystem["end_time"]); ?></td>
                                                                        <td><?php echo e($englishSubSystem["studio"]); ?></td>
                                                                        <?php if($englishSubSystem["current_date"]->gt($englishSubSystem["carbon_end_time"])): ?>
                                                                            <td style="width: 8px"><span class="badge bg-gradient-bloody text-white shadow-sm w-100"><?php echo e(__("messages.closed")); ?></span></td>
                                                                        <?php else: ?>
                                                                            <td><a href="<?php echo e($englishSubSystem["link"]); ?>" target="_blank"><span class="badge bg-gradient-quepal text-white shadow-sm w-100"><?php echo e(__("messages.join")); ?></span></a></td>
                                                                        <?php endif; ?>
                                                                    </tr>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            <?php else: ?>
                                                                <tr>
                                                                    <td colspan="12">
                                                                        <div class="alert alert-info border-0 bg-info">
                                                                            <div class="text-dark text-center" style="font-weight: bold"><?php echo e(__("messages.no_results_found")); ?></div>
                                                                        </div>
                                                                    </td>
                                                                </tr>
                                                            <?php endif; ?>
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="frenchSubSystem" role="tabpanel">
                                                    <div class="table-responsive">
                                                        <table class="table align-middle mb-0">
                                                            <thead class="table-light">
                                                            <tr>
                                                                <th><?php echo e(__("messages.exam")); ?></th>
                                                                <th><?php echo e(__("messages.subject")); ?></th>
                                                                <th><?php echo e(__("messages.topic")); ?></th>
                                                                <th><?php echo e(__("messages.date")); ?></th>
                                                                <th><?php echo e(__("messages.start_time")); ?></th>
                                                                <th><?php echo e(__("messages.end_time")); ?></th>
                                                                <th><?php echo e(__("messages.studio")); ?></th>
                                                                <th><?php echo e(__("messages.link")); ?></th>
                                                            </tr>
                                                            </thead>
                                                            <tbody>
                                                            <?php if(sizeof($frenchSubSystemArray) != 0): ?>
                                                                <?php $__currentLoopData = $frenchSubSystemArray; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $frenchSubSystem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <tr>
                                                                        <td><?php echo e($frenchSubSystem["exam"]); ?></td>
                                                                        <td><?php echo e($frenchSubSystem["subject"]); ?></td>
                                                                        <td><?php echo e($frenchSubSystem["topic"]); ?></td>
                                                                        <td><?php echo e($frenchSubSystem["date"]); ?></td>
                                                                        <td><?php echo e($frenchSubSystem["start_time"]); ?></td>
                                                                        <td><?php echo e($frenchSubSystem["end_time"]); ?></td>
                                                                        <td><?php echo e($frenchSubSystem["studio"]); ?></td>
                                                                        <?php if($frenchSubSystem["current_date"]->gt($frenchSubSystem["carbon_end_time"])): ?>
                                                                            <td style="width: 8px"><span class="badge bg-gradient-bloody text-white shadow-sm w-100"><?php echo e(__("messages.closed")); ?></span></td>
                                                                        <?php else: ?>
                                                                            <td><a href="<?php echo e($frenchSubSystem["link"]); ?>" target="_blank"><span class="badge bg-gradient-quepal text-white shadow-sm w-100"><?php echo e(__("messages.join")); ?></span></a></td>
                                                                        <?php endif; ?>
                                                                    </tr>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            <?php else: ?>
                                                                <tr>
                                                                    <td colspan="12">
                                                                        <div class="alert alert-info border-0 bg-info">
                                                                            <div class="text-dark text-center" style="font-weight: bold"><?php echo e(__("messages.no_results_found")); ?></div>
                                                                        </div>
                                                                    </td>
                                                                </tr>
                                                            <?php endif; ?>
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
                <!-- End section 2 -->

            </div>
        </div>
    </div>
</div>
<?php if ($__env->exists('layouts.default.footer')) echo $__env->make('layouts.default.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>
<!--end wrapper-->
<!-- Bootstrap JS -->
<script src="<?php echo e(asset('assets/js/bootstrap.bundle.min.js')); ?>"></script>
<!--plugins-->
<script src="<?php echo e(asset('assets/js/jquery.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/plugins/simplebar/js/simplebar.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/plugins/metismenu/js/metisMenu.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js')); ?>"></script>
<!--Password show & hide js -->
<script>
    $('#classInput').css('display', 'none'); // Hide the text input box in default
    $('#subEducationTypeInput').css('display', 'none'); // Hide the text input box in default
    $('#specialtyInput').css('display', 'none'); // Hide the text input box in default
    $('#specialtyClassInput').css('display', 'none'); // Hide the text input box in default
    $('#levelInput').css('display', 'none'); // Hide the text input box in default
    $('#levelClassInput').css('display', 'none'); // Hide the text input box in default

    $('#educationTypeDesignation').css('display', 'none'); // Hide the text input box in default

    $('#classInputDesignation').css('display', 'none'); // Hide the text input box in default

    $('#subEducationTypeDesignation').css('display', 'none'); // Hide the text input box in default
    $('#specialtyDesignation').css('display', 'none'); // Hide the text input box in default
    $('#specialtyClassDesignation').css('display', 'none'); // Hide the text input box in default

    $('#levelDesignation').css('display', 'none'); // Hide the text input box in default
    $('#levelClassDesignation').css('display', 'none'); // Hide the text input box in default

    $(document).ready(function () {
        var type = null;
        var subSystemId = null;
        var educationTypeOutPutId = null;
        var subEducationTypeId = null;
        var classId = null;
        var specialtyId = null;
        var specialtyClassId = null;
        var levelId = null;
        var levelClassId = null;

        var subjectId = null;
        // var levelClassId = null;
        // var levelClassId = null;

        $(document).on('click', '.selectSubSystem', function () {
            subSystemId = $(this).data('sub_system_id');
            if (subSystemId) {
                var div_data = "";
                $.ajax({
                    type: "GET",
                    url: "<?php echo e(route('home.education-type.get')); ?>?sub_system_id=" + subSystemId,
                    success: function (data) {
                        if (data) {
                            $.each(data, function (i, obj) {
                                $('#educationTypeDesignation').css('display', 'block');

                                $('#classInputDesignation').css('display', 'none');

                                $('#subEducationTypeDesignation').css('display', 'none');
                                $('#specialtyDesignation').css('display', 'none');
                                $('#specialtyClassDesignation').css('display', 'none');

                                $('#levelDesignation').css('display', 'none');
                                $('#levelClassDesignation').css('display', 'none');

                                div_data += "<div class='col'>";
                                div_data += "<div class='card'>";
                                div_data += "<a class='selectEducationType' href='javascript:void(0);' data-education_type_id='" + obj.id + obj.type + "'>";
                                div_data += "<img src='<?php echo asset('assets/images/general_education.png') ?>' class='card-img-top' height='90' width='90' alt='...'>";
                                div_data += "</a>";
                                div_data += "<div class='card-body'>";
                                div_data += "<h6 class='card-title text-center'>" + obj.designation;
                                div_data += "</h6>";
                                div_data += "</div>";
                                div_data += "</div>";
                                div_data += "</div>";
                            });
                            $('.educationTypes').html(div_data);
                        }
                    }
                });
            }
        });

        $(document).on('click', '.selectEducationType', function () {
            var educationTypeId = $(this).data('education_type_id');

            function processInput(educationTypeId) {
                var output = [];
                var json = educationTypeId.split(' '); // Split text by spaces into array

                json.forEach(function (item) { // Loop through each array item
                    var out = item.replace(/\'/g, ''); // Remove all single quote '  from chunk
                    out = out.split(/(\d+)/); // Now again split the chunk by Digits into array
                    out = out.filter(Boolean); // With Boolean we can filter out False Boolean Values like -> false, null, 0
                    output.push(out);
                });

                return output;
            }

            var outputId = processInput(educationTypeId[0]);
            var outputType = processInput(educationTypeId[1]);

            educationTypeOutPutId = outputId[0][0];
            var div_data = "";

            if (outputType == "G") {
                $.ajax({
                    type: "GET",
                    url: "<?php echo e(route('home.class.get')); ?>?education_type_id=" + outputId,
                    success: function (data) {
                        if (data) {
                            $('#classInputDesignation').css('display', 'block');

                            $('#subEducationTypeDesignation').css('display', 'none');
                            $('#specialtyDesignation').css('display', 'none');
                            $('#specialtyClassDesignation').css('display', 'none');

                            $('#levelDesignation').css('display', 'none');
                            $('#levelClassDesignation').css('display', 'none');

                            $('#classInput').css('display', 'block');
                            $('#subEducationTypeInput').css('display', 'none');
                            $('#specialtyInput').css('display', 'none');
                            $('#specialtyClassInput').css('display', 'none');
                            $('#levelInput').css('display', 'none');
                            $('#levelClassInput').css('display', 'none');

                            $.each(data, function (i, obj) {
                                div_data += "<div class='col'>";
                                div_data += "<div class='card'>";
                                div_data += "<div class='card-body'>";
                                div_data += "<div class='form-check'>";
                                div_data += "<input type='radio' class='selectClass form-check-input' id='class_id' name='class_id' value='" + obj.id + "'>";
                                div_data += "<label class='form-check-label'>" + obj.designation;
                                div_data += "</label>";
                                div_data += "</div>";
                                div_data += "</div>";
                                div_data += "</div>";
                                div_data += "</div>";
                            });
                            $('.class_radio_button').html(div_data);
                        }
                    }
                });
            }

            if (outputType == "T") {
                $.ajax({
                    type: "GET",
                    url: "<?php echo e(route('home.sub-education-type.get')); ?>?education_type_id=" + outputId,
                    success: function (data) {
                        if (data) {
                            $('#subEducationTypeDesignation').css('display', 'block');
                            $('#classInputDesignation').css('display', 'none');

                            $('#specialtyDesignation').css('display', 'none');
                            $('#specialtyClassDesignation').css('display', 'none');

                            $('#levelDesignation').css('display', 'none');
                            $('#levelClassDesignation').css('display', 'none');

                            $('#classInput').css('display', 'none');
                            $('#levelInput').css('display', 'none');
                            $('#levelClassInput').css('display', 'none');
                            $('#subEducationTypeInput').css('display', 'block');
                            $('#specialtyInput').css('display', 'block');
                            $('#specialtyClassInput').css('display', 'block');
                            $.each(data, function (i, obj) {
                                div_data += "<div class='col'>";
                                div_data += "<div class='card'>";
                                div_data += "<div class='card-body'>";
                                div_data += "<div class='form-check'>";
                                div_data += "<input type='radio' class='selectSuEducationType form-check-input' id='sub_education_type_id' name='sub_education_type_id' value='" + obj.id + "'>";
                                div_data += "<label class='form-check-label'>" + obj.designation;
                                div_data += "</label>";
                                div_data += "</div>";
                                div_data += "</div>";
                                div_data += "</div>";
                                div_data += "</div>";
                            });
                            $('.sub_education_type_radio_button').html(div_data);
                        }
                    }
                });
            }

            if (outputType == "E") {
                $.ajax({
                    type: "GET",
                    url: "<?php echo e(route('home.levels.get')); ?>?education_type_id=" + outputId,
                    success: function (data) {
                        if (data) {
                            $('#levelDesignation').css('display', 'block');

                            $('#classInputDesignation').css('display', 'none');
                            $('#subEducationTypeDesignation').css('display', 'none');
                            $('#specialtyDesignation').css('display', 'none');
                            $('#specialtyClassDesignation').css('display', 'none');

                            $('#levelClassDesignation').css('display', 'none');

                            $('#classInput').css('display', 'none');
                            $('#subEducationTypeInput').css('display', 'none');
                            $('#specialtyInput').css('display', 'none');
                            $('#specialtyClassInput').css('display', 'none');
                            $('#levelInput').css('display', 'block');
                            $('#levelClassInput').css('display', 'block');
                            $.each(data, function (i, obj) {
                                div_data += "<div class='col'>";
                                div_data += "<div class='card'>";
                                div_data += "<div class='card-body'>";
                                div_data += "<div class='form-check'>";
                                div_data += "<input type='radio' class='selectLevel form-check-input' id='level_id' name='level_id' value='" + obj.id + "'>";
                                div_data += "<label class='form-check-label'>" + obj.designation;
                                div_data += "</label>";
                                div_data += "</div>";
                                div_data += "</div>";
                                div_data += "</div>";
                                div_data += "</div>";
                            });
                            $('.level_radio_button').html(div_data);
                        }
                    }
                });
            }
        });

        $(document).on('click', '.selectSuEducationType', function () {
            subEducationTypeId = $(this).val();
            if (subEducationTypeId) {
                var div_data = "";
                $.ajax({
                    type: "GET",
                    url: "<?php echo e(route('home.specialty.get')); ?>?sub_education_type_id=" + subEducationTypeId,
                    success: function (data) {
                        if (data) {
                            $('#specialtyDesignation').css('display', 'block');

                            $('#specialtyClassDesignation').css('display', 'none');

                            $('#classInput').css('display', 'none');
                            $('#subEducationTypeInput').css('display', 'none');
                            $('#specialtyInput').css('display', 'block');
                            $('#specialtyClassInput').css('display', 'block');
                            $('#levelInput').css('display', 'none');
                            $('#levelClassInput').css('display', 'none');
                            $.each(data, function (i, obj) {
                                div_data += "<div class='col'>";
                                div_data += "<div class='card'>";
                                div_data += "<div class='card-body'>";
                                div_data += "<div class='form-check'>";
                                div_data += "<input type='radio' class='selectSpecialty form-check-input' id='specialty_id' name='specialty_id' value='" + obj.id + "'>";
                                div_data += "<label class='form-check-label'>" + obj.designation;
                                div_data += "</label>";
                                div_data += "</div>";
                                div_data += "</div>";
                                div_data += "</div>";
                                div_data += "</div>";
                            });
                            $('.specialty_radio_button').html(div_data);
                        }
                    }
                });
            }
        });

        $(document).on('click', '.selectSpecialty', function () {
            specialtyId = $(this).val();
            if (specialtyId) {
                $.ajax({
                    type: "GET",
                    url: "<?php echo e(route('home.class.get-specialty-classes')); ?>?specialty_id=" + specialtyId,
                    success: function (data) {
                        var div_data = "";
                        if (data) {
                            $('#specialtyClassDesignation').css('display', 'block');

                            $('#classInput').css('display', 'none');
                            $('#subEducationTypeInput').css('display', 'none');
                            $('#specialtyInput').css('display', 'block');
                            $('#specialtyClassInput').css('display', 'block');
                            $('#levelInput').css('display', 'none');
                            $('#levelClassInput').css('display', 'none');
                            $.each(data, function (i, obj) {
                                div_data += "<div class='col'>";
                                div_data += "<div class='card'>";
                                div_data += "<div class='card-body'>";
                                div_data += "<div class='form-check'>";
                                div_data += "<input type='radio' class='selectSpecialtyClass form-check-input' id='specialty_class_id' name='specialty_class_id' value='" + obj.id + "'>";
                                div_data += "<label class='form-check-label'>" + obj.designation;
                                div_data += "</label>";
                                div_data += "</div>";
                                div_data += "</div>";
                                div_data += "</div>";
                                div_data += "</div>";
                            });
                            $('.specialty_class_radio_button').html(div_data);
                        }
                    }
                });
            }
        });

        $(document).on('click', '.selectLevel', function () {
            levelId = $(this).val();
            if (levelId) {
                var div_data = "";
                $.ajax({
                    type: "GET",
                    url: "<?php echo e(route('home.level-classes.get')); ?>?level_id=" + levelId,
                    success: function (data) {
                        if (data) {
                            $('#levelClassDesignation').css('display', 'block');

                            $('#classInput').css('display', 'none');
                            $('#subEducationTypeInput').css('display', 'none');
                            $('#specialtyInput').css('display', 'none');
                            $('#specialtyClassInput').css('display', 'none');

                            $('#levelInput').css('display', 'block');
                            $('#levelClassInput').css('display', 'block');
                            $.each(data, function (i, obj) {
                                div_data += "<div class='col'>";
                                div_data += "<div class='card'>";
                                div_data += "<div class='card-body'>";
                                div_data += "<div class='form-check'>";
                                div_data += "<input type='radio' class='selectLevelClass form-check-input' id='level_class_id' name='level_class_id' value='" + obj.id + "'>";
                                div_data += "<label class='form-check-label'>" + obj.designation;
                                div_data += "</label>";
                                div_data += "</div>";
                                div_data += "</div>";
                                div_data += "</div>";
                                div_data += "</div>";
                            });
                            $('.level_class_radio_button').html(div_data);
                        }
                    }
                });
            }
        });

        $(document).on('click', '.selectClass', function () {
            classId = $(this).val();
            if (classId) {
                var div_data = "";
                $.ajax({
                    url: "<?php echo e(route('home.get-class-subjects')); ?>",
                    type: "POST",
                    data: {
                        "_token": "<?php echo e(csrf_token()); ?>",
                        type: "Gen",
                        education_type_id: educationTypeOutPutId,
                        class_id: classId,
                    },
                    timeout: 6000,
                    dataType: "json",
                    beforeSend: function (xhr, settings) {
                    },
                    success: function (data) {
                        if (data) {
                            $.each(data.data, function (i, obj) {
                                div_data += "<a href='javascript:void(0);' class='list-group-item d-flex align-items-center loadClassSubjects' data-subject_id='" + obj.id + "'>";
                                div_data += "<i class='bx bxs-book me-3 font-20'>";
                                div_data += "</i>";
                                div_data += "<span>" + obj.designation;
                                div_data += "<span>";
                                div_data += "</a>";
                            });
                            $('.class_subjects').html(div_data);
                        }
                    },
                    error: function (xhr, textStatus, errorThrown) {
                    }
                });
            }
        });

        $(document).on('click', '.loadClassSubjects', function () {
            subjectId = $(this).data('subject_id');
            if (subjectId) {
                var div_data = "";
                $.ajax({
                    url: "<?php echo e(route('home.lessons.get-subject-lessons')); ?>",
                    type: "POST",
                    data: {
                        "_token": "<?php echo e(csrf_token()); ?>",
                        type: "Gen",
                        sub_system_id: subSystemId,
                        education_type_id: educationTypeOutPutId,
                        class_id: classId,
                        subject_id: subjectId,
                    },
                    timeout: 6000,
                    dataType: "json",
                    beforeSend: function (xhr, settings) {
                    },
                    success: function (data) {
                        if (data) {
                            console.log("CLASS SUBJECTS LOADED HERE")
                            console.log(data)
                            console.log("CLASS SUBJECTS LOADED HERE")
                            $.each(data.data, function (i, obj) {
                                div_data += "<div class='col'>";
                                div_data += "<div class='card border-success border-bottom border-3 border-0'>";
                                div_data += "<img src='" + obj.lesson_image + "' class='card-img-top' alt='...'>";
                                div_data += "<div class='card-body'>";
                                div_data += "<h5 class='card-title text-success' >" + obj.title
                                div_data += "</h5>";
                                div_data += "<p class='card-text'>" + obj.description
                                div_data += "</p>";
                                // div_data += "<div class='d-flex align-items-center gap-2'>";
                                // div_data += "<a href='javascript:;' class='btn btn-inverse-success'>";
                                // div_data += "<i class='bx bx-star'>";
                                // div_data += "</i>" + "view"
                                // div_data += "</a>";
                                // div_data += "<a href='javascript:;' class='btn btn-success'><i class='bx bx-microphone'>";
                                // div_data += "</i>" + "View"
                                // div_data += "</a>";
                                // div_data += "</div>";
                                div_data += "</div>";
                                div_data += "</div>";
                                div_data += "</div>";
                            });

                            $('.class_lessons').html(div_data);
                        }
                    },
                    error: function (xhr, textStatus, errorThrown) {
                    }
                });
            }
        });

        $(document).on('click', '.selectSpecialtyClass', function () {
            specialtyClassId = $(this).val();
            if (specialtyClassId) {
                var div_data = "";
                $.ajax({
                    url: "<?php echo e(route('home.get-class-subjects')); ?>",
                    type: "POST",
                    data: {
                        "_token": "<?php echo e(csrf_token()); ?>",
                        type: "Tech",
                        specialty_id: specialtyId,
                        specialty_class_id: specialtyClassId,
                    },
                    timeout: 6000,
                    dataType: "json",
                    beforeSend: function (xhr, settings) {
                    },
                    success: function (data) {
                        if (data) {
                            $.each(data.data, function (i, obj) {
                                div_data += "<a class='list-group-item d-flex align-items-center'>";
                                div_data += "<i class='bx bxs-book me-3 font-20'>";
                                div_data += "</i>";
                                div_data += "<span>" + obj.designation;
                                div_data += "<span>";
                                div_data += "</a>";
                            });
                            $('.class_subjects').html(div_data);
                        }
                    },
                    error: function (xhr, textStatus, errorThrown) {
                    }
                });
            }
        });

        $(document).on('click', '.selectLevelClass', function () {
            levelClassId = $(this).val();
            if (levelClassId) {
                var div_data = "";
                $.ajax({
                    url: "<?php echo e(route('home.get-class-subjects')); ?>",
                    type: "POST",
                    data: {
                        "_token": "<?php echo e(csrf_token()); ?>",
                        type: "EN",
                        level_id: levelId,
                        level_class_id: levelClassId,
                    },
                    timeout: 6000,
                    dataType: "json",
                    beforeSend: function (xhr, settings) {
                    },
                    success: function (data) {
                        if (data) {
                            $.each(data.data, function (i, obj) {
                                div_data += "<a class='list-group-item d-flex align-items-center'>";
                                div_data += "<i class='bx bxs-book me-3 font-20'>";
                                div_data += "</i>";
                                div_data += "<span>" + obj.designation;
                                div_data += "<span>";
                                div_data += "</a>";
                            });
                            $('.class_subjects').html(div_data);
                        }
                    },
                    error: function (xhr, textStatus, errorThrown) {
                    }
                });
            }
        });

        $("#show_hide_password a").on('click', function (event) {
            event.preventDefault();
            if ($('#show_hide_password input').attr("type") == "text") {
                $('#show_hide_password input').attr('type', 'password');
                $('#show_hide_password i').addClass("bx-hide");
                $('#show_hide_password i').removeClass("bx-show");
            } else if ($('#show_hide_password input').attr("type") == "password") {
                $('#show_hide_password input').attr('type', 'text');
                $('#show_hide_password i').removeClass("bx-hide");
                $('#show_hide_password i').addClass("bx-show");
            }
        });
    });
    new PerfectScrollbar('.email-navigation');
    new PerfectScrollbar('.email-list');
</script>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\minesec-distance-education-web\resources\views/welcome.blade.php ENDPATH**/ ?>