<?php $__env->startSection('title', sprintf('%s - %s', __('messages.lessons'), __(config('app.name')))); ?>

<?php $__env->startSection("style"); ?>
    <link href="<?php echo e(asset('assets/plugins/input-tags/css/tagsinput.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('assets/css/custom.css')); ?>" rel="stylesheet" />
    <style>
        .progress {
            position:relative;
            width:100%;
        }
        .bar {
            background-color: #00ff00;
            width:0;
            height:20px;
        }
        .percent {
            position:absolute;
            display:inline-block;
            left:50%;
            color: #040608;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection("wrapper"); ?>
    <!--start page wrapper -->
    <div class="page-wrapper">
        <div class="page-content">
            <!--breadcrumb-->
            <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
                <div class="breadcrumb-title pe-3"><?php echo e(__("messages.lessons")); ?></div>
            </div>
            <!--end breadcrumb-->

            <div class="card">
                <div class="card-body">
                    <div class="d-lg-flex align-items-center mb-4 gap-3">
                        <div class="position-relative">
                            <input type="text" class="form-control ps-5 radius-30" placeholder="<?php echo e(__("messages.search")); ?>"> <span class="position-absolute top-50 product-show translate-middle-y"><i class="bx bx-search"></i></span>
                        </div>
                        <div class="ms-auto"><button type="button" class="btn btn-primary radius-30 mt-2 mt-lg-0" data-bs-toggle="modal" data-bs-target="#lessonModal"><i class="bx bxs-plus-square"></i><?php echo e(__("messages.add_lesson")); ?></button></div>
                    </div>

                    <div class="table-responsive">
                        <table class="table mb-0">
                            <thead class="table-light">
                            <tr>
                                <th><?php echo e(__("messages.class")); ?></th>
                                <th><?php echo e(__("messages.subject")); ?></th>
                                <th><?php echo e(__("messages.title")); ?></th>
                                <th><?php echo e(__("messages.description")); ?></th>
                                <th>Total</th>
                                <th>View Details</th>
                                <th>Actions</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $lessons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lesson): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo $lesson->{'className'}->{'designation'} ?></td>
                                    <td><?php echo $lesson->{'subject'}->{'designation'} ?></td>
                                    <td><?php echo $lesson->{'title'} ?></td>
                                    <td><?php echo $lesson->{'description'} ?></td>
                                    <td><div class="badge rounded-pill text-success bg-light-success p-2 text-uppercase px-3"><i class='bx bxs-circle me-1'></i>30</div></td>
                                    <td><button type="button" class="btn btn-primary btn-sm radius-30 px-4">View Details</button></td>
                                    <td>
                                        <div class="d-flex order-actions">
                                            <a href="#" class=""><i class='bx bxs-edit'></i></a>
                                            <a href="<?php echo e(route("lesson.delete", $lesson->{"id"})); ?>" class="ms-3"><i class='bx bxs-trash'></i></a>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>

                    <!-- Modal -->
                    <form class="needs-validation" novalidate enctype="multipart/form-data" action="<?php echo e(route("lesson.create")); ?>" method="post">
                        <?php echo csrf_field(); ?>
                        <div class="modal fade" id="lessonModal" tabindex="-1" aria-hidden="true">
                            <div class="modal-dialog  modal-xl modal-dialog-scrollable">
                                <div class="modal-content">

                                    <div class="modal-header">
                                        <h5 class="modal-title"><?php echo e(__("messages.add_lesson")); ?></h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                    </div>

                                    <div class="modal-body">
                                        <div class="row">
                                            <div class="col-md-3">
                                                <label for="validationCustom04" class="form-label"><?php echo e(__("messages.sub_systems")); ?></label>
                                                <select class="form-select" id="sub_system_id" name="sub_system_id" required><option selected disabled value=""><?php echo e(__("messages.select")); ?></option>
                                                    <?php $__currentLoopData = $subSystems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subSystem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($subSystem->{"id"}); ?>"><?php echo e($subSystem->{"designation"}); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                                <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                            </div>

                                            <div class="col-md-3">
                                                <label for="validationTooltip01" class="form-label"><?php echo e(__("messages.education_type")); ?></label>
                                                <select class="form-select" id="education_type_id" name="education_type_id" required aria-label="select example">
                                                </select>
                                                <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                            </div>

                                            <div class="col-md-3" id="subEducationTypeInput">
                                                <label for="validationTooltip01" class="form-label"><?php echo e(__("messages.sub_education_type")); ?></label>
                                                <select class="form-select" id="sub_education_type_id" name="sub_education_type_id"  aria-label="select example">
                                                </select>
                                                <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                            </div>

                                            <div class="col-md-3" id="specialtyInput">
                                                <label for="validationTooltip01" class="form-label"><?php echo e(__("messages.specialty")); ?></label>
                                                <select class="form-select" id="specialty_id" name="specialty_id"  aria-label="select example">
                                                </select>
                                                <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                            </div>

                                            <div class="col-md-3" id="levelInput">
                                                <label for="validationTooltip01" class="form-label"><?php echo e(__("messages.level")); ?></label>
                                                <select class="form-select" id="level_id" name="level_id"  aria-label="select example">
                                                </select>
                                                <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                            </div>

                                            <div class="col-md-3">
                                                <label for="validationCustom04" class="form-label"><?php echo e(__("messages.term")); ?></label>
                                                <select class="form-select" id="term_id" name="term_id" required> <option selected disabled value=""><?php echo e(__("messages.select")); ?></option>
                                                    <?php $__currentLoopData = $terms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $term): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($term->{"id"}); ?>"><?php echo e($term->{"designation"}); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                                <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                            </div>

                                        </div>

                                        <hr/>
                                        <h6 class="modal-title"><?php echo e(__("messages.classes")); ?></h6>
                                        <div class="row" id="classInput">
                                            <div class="col-md-3 class_checkbox">
                                            <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                            </div>
                                        </div>

                                        <div class="row" id="specialtyClassInput">
                                            <div class="col-md-3 specialtyClass_checkbox">
                                                <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                            </div>
                                        </div>

                                        <div class="row" id="levelClassInput">
                                            <div class="col-md-3 levelClass_checkbox">
                                                <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                            </div>
                                        </div>

                                        <hr/>
                                        <div class="row">
                                            <h6 class="modal-title"><?php echo e(__("messages.subjects")); ?></h6>
                                            <div class="col-md-3 subject_checkbox">
                                            </div>
                                        </div>

                                        <hr/>
                                        <div class="row">
                                            <div class="col-md-3">
                                                    <label for="validationCustom04" class="form-label"><?php echo e(__("messages.upload_type")); ?></label>
                                                    <select class="form-select" id="upload_type" name="upload_type" required> <option selected disabled value=""><?php echo e(__("messages.select")); ?></option>
                                                        <?php $__currentLoopData = $resourceDestination; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $vale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($key); ?>"><?php echo e($vale); ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                    <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                                </div>
                                        </div>

                                        <hr/>
                                        <div class="row form-group" id="destinationLocalServer">
                                        <div class="row-cols-6">
                                            <div class="col-md-4">
                                                <label for="validationCustom03" class="form-label"><?php echo e(__("messages.video")); ?></label>
                                                <input type="file" class="form-control" name="lesson_video" id="video-field" aria-label="file example" required>
                                                <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                                <hr/>
                                                <div class="progress">
                                                    <div class="bar"></div>
                                                    <div class="percent">0%</div >
                                                </div>
                                            </div>

                                            <div class="col-md-4">
                                                <label for="validationCustom03" class="form-label"><?php echo e(__("messages.title")); ?></label>
                                                <input type="text" class="form-control" name="lesson_title" id="title-field" required>
                                                <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                                <hr/>
                                                <div id="success"></div>
                                            </div>

                                            <div class="col-md-4">
                                                <label for="validationTextarea" class="form-label"><?php echo e(__("messages.description")); ?></label>
                                                <textarea class="form-control" name="lesson_description" id="description-field" placeholder="<?php echo e(__("messages.lesson_description")); ?>" required></textarea>
                                                <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                            </div>
                                        </div>
                                        </div>

                                        <div class="row form-group" id="destinationYouTube">
                                            <div class="col-md-4">
                                                <label for="validationCustom03" class="form-label"><?php echo e(__("messages.you_tube_link")); ?></label>
                                                <input type="url" class="form-control" name="you_tube_link" id="you_tube_link" required>
                                                <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                            </div>

                                            <div class="col-md-4">
                                                <label for="validationCustom03" class="form-label"><?php echo e(__("messages.title")); ?></label>
                                                <input type="text" class="form-control" name="lesson_title" id="title-field" required>
                                                <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                                <div id="success"></div>
                                            </div>

                                            <div class="col-md-4">
                                                <label for="validationTextarea" class="form-label"><?php echo e(__("messages.description")); ?></label>
                                                <textarea class="form-control" name="lesson_description" id="description-field" placeholder="<?php echo e(__("messages.lesson_description")); ?>" required></textarea>
                                                <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                            </div>
                                        </div>

                                    </div>

                                    <div class="modal-footer">
                                        <div id="cancel-button">
                                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(__("messages.close")); ?></button>
                                        </div>

                                        <div id="save-button">
                                            <button type="submit" class="btn btn-primary"><?php echo e(__("messages.save")); ?></button>
                                        </div>

                                        <div id="loader" class="visible">
                                            <button class="btn btn-primary " type="button" > <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span><?php echo e(__("messages.uploading")); ?></button>
                                        </div>

                                    </div>

                                </div>
                            </div>
                        </div>
                    </form>

                </div>
            </div>

        </div>
    </div>
    <!--end page wrapper -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection("script"); ?>
    <script src="<?php echo e(asset('assets/plugins/input-tags/js/tagsinput.js')); ?>"></script>

    <script src="<?php echo e(asset('assets/js/custom/jquery.form.js')); ?>"></script>
    <script type="text/javascript">
        $(function () {
            $(document).ready(function () {
                var bar = $('.bar');
                var percent = $('.percent');
                $('form').ajaxForm({
                    beforeSend: function () {
                        $("#loader").css("display", "block");
                        $("#save-button").hide();
                        $("#cancel-button").hide();
                        var percentVal = '0%';
                        bar.width(percentVal)
                        percent.html(percentVal);
                        $('#success').empty();
                    },
                    uploadProgress: function (event, position, total, percentComplete) {
                        $("#sub_system_id").prop("disabled", true);
                        $("#education_type_id").prop("disabled", true);
                        $("#class_id").prop("disabled", true);
                        $("#sub_education_type_id").prop("disabled", true);
                        $("#level_id").prop("disabled", true);
                        $("#level_class_id").prop("disabled", true);
                        $("#specialty_id").prop("disabled", true);
                        $("#specialty_class_id").prop("disabled", true);
                        $("#term_id").prop("disabled", true);

                        $("#subject-field").prop("disabled", true);
                        $("#video-field").prop("disabled", true);
                        $("#title-field").prop("disabled", true);
                        $("#description-field").prop("disabled", true);
                        $(':input[type="button"]').prop('disabled', true);


                        $("#loader").css("display", "block");
                        $("#save-button").hide();
                        $("#cancel-button").hide();
                        var percentVal = percentComplete + '%';
                        bar.width(percentVal)
                        percent.html(percentVal);
                    },

                    complete: function (data) {
                        if(data.responseJSON.error)
                        {
                            $("#loader").hide();
                            $("#save-button").css("display", "block");
                            $("#cancel-button").css("display", "block");
                            $('#success').html('<span class="text-danger"><b>'+data.responseJSON.error+'</b></span>');
                            window.setTimeout(function(){location.reload()},3000)
                        }
                        if(data.responseJSON.success)
                        {
                            $("#sub_system_id").prop("disabled", true);
                            $("#education_type_id").prop("disabled", true);
                            $("#class_id").prop("disabled", true);
                            $("#sub_education_type_id").prop("disabled", true);
                            $("#levelInput").prop("disabled", true);
                            $("#levelClassInput").prop("disabled", true);
                            $("#specialty_id").prop("disabled", true);
                            $("#specialty_class_id").prop("disabled", true);
                            $("#term_id").prop("disabled", true);
                            $("#subject-field").prop("disabled", true);
                            $("#video-field").prop("disabled", true);
                            $("#title-field").prop("disabled", true);
                            $("#description-field").prop("disabled", true);
                            $(':input[type="button"]').prop('disabled', true);
                            $('#success').html('<span class="text-success"><b>'+data.responseJSON.success+'</b></span>');
                            $("#loader").hide();
                            $("#save-button").hide();
                            $("#cancel-button").hide();

                            window.setTimeout(function(){location.reload()},3000)
                        }
                    }
                });

                $(document).on('change', '#upload_type', function (e) {
                    const upload_type = $('#upload_type').val();
                    if(upload_type == 'local_server') {
                        $('#destinationLocalServer').css('display', 'block');
                        $('#destinationYouTube').css('display', 'none');
                    } else  {
                        $('#destinationLocalServer').css('display', 'none');
                        $('#destinationYouTube').css('display', 'block');
                    }
                });
            });
        });
    </script>

    <script>
        // Example starter JavaScript for disabling form submissions if there are invalid fields
        (function () {
            'use strict'
            // Fetch all the forms we want to apply custom Bootstrap validation styles to
            var forms = document.querySelectorAll('.needs-validation')
            // Loop over them and prevent submission
            Array.prototype.slice.call(forms)
                .forEach(function (form) {
                    form.addEventListener('submit', function (event) {
                        if (!form.checkValidity()) {
                            event.preventDefault()
                            event.stopPropagation()
                        }
                        form.classList.add('was-validated')
                    }, false)
                })
        })()
    </script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make("layouts.admin.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\minesec-distance-education-web\resources\views/admin/lesson/index.blade.php ENDPATH**/ ?>