<?php

use App\Http\Controllers\Api\ClassController;
use App\Http\Controllers\Api\LessonController;
use App\Http\Controllers\Api\SubjectController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/


Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});


Route::prefix('v1')->group(function () {

    Route::prefix('classes')->group(function () {
        Route::get('sub-systems', [ClassController::class, 'getSubsystems'])->name('class.get-sub-system');
        Route::post('education-types', [ClassController::class, 'getEducationTypes'])->name('class.get-education-type');
        Route::post('sub-education-types', [ClassController::class, 'getSubEducationTypes'])->name('class.get-sub-education-type');
        Route::post('levels', [ClassController::class, 'getLevels'])->name('class.get-level');
        Route::post('level-classes', [ClassController::class, 'getLevelClasses'])->name('class.get-level-class');
        Route::post('specialties', [ClassController::class, 'getSpecialties'])->name('class.get-specialty');
        Route::post('specialty-classes', [ClassController::class, 'getSpecialtyClasses'])->name('class.get-specialty-class');
        Route::post('classes', [ClassController::class, 'getCLasses'])->name('class.get-classes');
    });

    Route::post('class-subjects', [SubjectController::class, 'getClassSubjects'])->name('subject.get-class-subjects');

    Route::prefix('lessons')->group(function (){
        Route::get('/', [LessonController::class, 'index'])->name('lesson.index');
        Route::post('class/subject', [LessonController::class, 'getSubjectLessons'])->name('lessons.get-subject-lessons');
    });

});
