<?php
$languages = app('languages');
$user = auth()->user();
$userLocale = $user->{"locale"};
$sessionLocale = app()->getLocale();
?>
<!doctype html>
<html lang="en">
<head>
	<!-- Required meta tags -->
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">
	<!--favicon-->
    <link rel="icon" href="{{asset('assets/images/favicon.png')}}" type="image/png" />
	<!--plugins-->
	@yield("style")
    <link href="{{asset('assets/plugins/simplebar/css/simplebar.css')}}" rel="stylesheet" />
    <link href="{{asset('assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css')}}" rel="stylesheet" />
    <link href="{{asset('assets/plugins/metismenu/css/metisMenu.min.css')}}" rel="stylesheet" />
    <!-- loader-->
    <link href="{{asset('assets/css/pace.min.css')}}" rel="stylesheet" />
    <script src="{{asset('assets/js/pace.min.js')}}"></script>

    <!-- Bootstrap CSS -->
    <link href="{{asset('assets/css/bootstrap.min.css')}}" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">
    <link href="{{asset('assets/css/app.css')}}" rel="stylesheet">
    <link href="{{asset('assets/css/icons.css')}}" rel="stylesheet">

    <!-- Theme Style CSS -->
    <link rel="stylesheet" href="{{asset('assets/css/dark-theme.css')}}" />
    <link rel="stylesheet" href="{{asset('assets/css/semi-dark.css')}}" />
    <link rel="stylesheet" href="{{asset('assets/css/header-colors.css')}}" />
    <title>@yield('title')</title>
</head>

<body>
	<!--wrapper-->
	<div class="wrapper">
		<!--start header -->
		@include("layouts.admin.header")
		<!--end header -->
		<!--navigation-->
		@include("layouts.admin.nav")
		<!--end navigation-->
		<!--start page wrapper -->
		@yield("wrapper")
		<!--end page wrapper -->
		<!--start overlay-->
		<div class="overlay toggle-icon"></div>
		<!--end overlay-->
		<!--Start Back To Top Button--> <a href="javaScript:;" class="back-to-top"><i class='bx bxs-up-arrow-alt'></i></a>
		<!--End Back To Top Button-->
		<footer class="page-footer">
			<p class="mb-0">Copyright © <script>document.write(new Date().getFullYear())</script>. {{__("messages.all_rights_reserve")}}</p>
		</footer>
	</div>
	<!--end wrapper-->

    <!--start switcher-->
    <div class="switcher-wrapper">
        <div class="switcher-btn"> <i class='bx bx-cog bx-spin'></i>
        </div>
        <div class="switcher-body">
            <div class="d-flex align-items-center">
                <h5 class="mb-0 text-uppercase">Theme Customizer</h5>
                <button type="button" class="btn-close ms-auto close-switcher" aria-label="Close"></button>
            </div>
            <hr/>
            <h6 class="mb-0">Theme Styles</h6>
            <hr/>
            <div class="d-flex align-items-center justify-content-between">
                <div class="form-check">
                    <input class="form-check-input" type="radio" name="flexRadioDefault" id="lightmode" checked>
                    <label class="form-check-label" for="lightmode">Light</label>
                </div>
                <div class="form-check">
                    <input class="form-check-input" type="radio" name="flexRadioDefault" id="darkmode">
                    <label class="form-check-label" for="darkmode">Dark</label>
                </div>
                <div class="form-check">
                    <input class="form-check-input" type="radio" name="flexRadioDefault" id="semidark">
                    <label class="form-check-label" for="semidark">Semi Dark</label>
                </div>
            </div>
            <hr/>
            <div class="form-check">
                <input class="form-check-input" type="radio" id="minimaltheme" name="flexRadioDefault">
                <label class="form-check-label" for="minimaltheme">Minimal Theme</label>
            </div>
            <hr/>
            <h6 class="mb-0">Header Colors</h6>
            <hr/>
            <div class="header-colors-indigators">
                <div class="row row-cols-auto g-3">
                    <div class="col">
                        <div class="indigator headercolor1" id="headercolor1"></div>
                    </div>
                    <div class="col">
                        <div class="indigator headercolor2" id="headercolor2"></div>
                    </div>
                    <div class="col">
                        <div class="indigator headercolor3" id="headercolor3"></div>
                    </div>
                    <div class="col">
                        <div class="indigator headercolor4" id="headercolor4"></div>
                    </div>
                    <div class="col">
                        <div class="indigator headercolor5" id="headercolor5"></div>
                    </div>
                    <div class="col">
                        <div class="indigator headercolor6" id="headercolor6"></div>
                    </div>
                    <div class="col">
                        <div class="indigator headercolor7" id="headercolor7"></div>
                    </div>
                    <div class="col">
                        <div class="indigator headercolor8" id="headercolor8"></div>
                    </div>
                </div>
            </div>
            <hr/>
            <h6 class="mb-0">Sidebar Colors</h6>
            <hr/>
            <div class="header-colors-indigators">
                <div class="row row-cols-auto g-3">
                    <div class="col">
                        <div class="indigator sidebarcolor1" id="sidebarcolor1"></div>
                    </div>
                    <div class="col">
                        <div class="indigator sidebarcolor2" id="sidebarcolor2"></div>
                    </div>
                    <div class="col">
                        <div class="indigator sidebarcolor3" id="sidebarcolor3"></div>
                    </div>
                    <div class="col">
                        <div class="indigator sidebarcolor4" id="sidebarcolor4"></div>
                    </div>
                    <div class="col">
                        <div class="indigator sidebarcolor5" id="sidebarcolor5"></div>
                    </div>
                    <div class="col">
                        <div class="indigator sidebarcolor6" id="sidebarcolor6"></div>
                    </div>
                    <div class="col">
                        <div class="indigator sidebarcolor7" id="sidebarcolor7"></div>
                    </div>
                    <div class="col">
                        <div class="indigator sidebarcolor8" id="sidebarcolor8"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--end switcher-->

	<!-- Bootstrap JS -->
	<script src="{{asset('assets/js/bootstrap.bundle.min.js')}}"></script>
	<!--plugins-->
	<script src="{{asset('assets/js/jquery.min.js')}}"></script>
	<script src="{{asset('assets/plugins/simplebar/js/simplebar.min.js')}}"></script>
	<script src="{{asset('assets/plugins/metismenu/js/metisMenu.min.js')}}"></script>
	<script src="{{asset('assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js')}}"></script>
	<!--app JS-->
	<script src="{{asset('assets/js/app.js')}}"></script>
    <script>
        $(document).ready(function (e) {
            $('#locale_en').on('click', function () {
                changeToEnglish();
            });

            $('#locale_fr').on('click', function () {
                changeToFrench();
            });
        });

        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        function changeToEnglish() {
            var locale_en = $("#locale_en").val();
            $.ajax({
                url: "{{ route('changLanguage') }}",
                type: "POST",
                // async: true,
                data: {
                    locale: locale_en,
                    requestType: "CL",
                },
                timeout: 6000,
                dataType: "json",
                beforeSend: function (xhr, settings) {
                },
                success: function (data) {
                    console.log(data);
                    window.location.reload('true');
                },
                error: function (xhr, textStatus, errorThrown) {
                }
            });
        }

        function changeToFrench() {
            var locale_fr = $("#locale_fr").val();
            $.ajax({
                url: "{{ route('changLanguage') }}",
                type: "POST",
                // async: true,
                data: {
                    locale: locale_fr,
                    requestType: "CL",
                },
                timeout: 6000,
                dataType: "json",
                beforeSend: function (xhr, settings) {
                },
                success: function (data) {
                    console.log(data);
                    window.location.reload('true');
                },
                error: function (xhr, textStatus, errorThrown) {
                }
            });
        }
    </script>

    <script>
        $('#classInput').css('display', 'none'); // Hide the text input box in default
        $('#subEducationTypeInput').css('display', 'none'); // Hide the text input box in default
        $('#specialtyInput').css('display', 'none'); // Hide the text input box in default
        $('#specialtyClassInput').css('display', 'none'); // Hide the text input box in default
        $('#levelInput').css('display', 'none'); // Hide the text input box in default
        $('#levelClassInput').css('display', 'none'); // Hide the text input box in default
        $('#destinationLocalServer').css('display', 'none'); // Hide the text input box in default
        $('#destinationYouTube').css('display', 'none'); // Hide the text input box in default

        // when sub system dropdown changes
        $('#sub_system_id').change(function() {
            var subSystemId = $(this).val();
            if (subSystemId) {
                $.ajax({
                    type: "GET",
                    url: "{{ route('education-type.get') }}?sub_system_id=" + subSystemId,
                    success: function(data) {
                        if (data) {
                            $("#education_type_id").empty();
                            $("#education_type_id").append('<option value="">{{__("messages.select")}}</option>');
                            $.each(data, function(key, value) {
                                $("#education_type_id").append('<option value="' + value.id + value.type +' ">' + value.designation +'</option>');
                            });
                        } else {
                            $("#education_type_id").empty();
                        }
                    }
                });

                var div_data = "";
                $.ajax({
                    type: "GET",
                    url: "{{ route('subject.get-sub-system-subjects') }}?sub_system_id=" + subSystemId,
                    success: function(data) {
                        if (data) {
                            $.each(data, function (i, obj)
                            {
                                var check = "";
                                // if (jQuery.inArray(obj.id, post_section_array) !== -1) {
                                //     check = "checked";
                                // }
                                div_data += "<div class='form-check'>";
                                div_data += "<label>";
                                div_data += "<input type='checkbox' class='form-check-input' name='subjectIds[]' value='" + obj.id + "' " + check + ">" + obj.designation;
                                div_data += "</label>";
                                div_data += "</div>";
                            });
                            $('.subject_checkbox').html(div_data);
                        }
                    }
                });
            } else {
                $("#education_type_id").empty();
                $("#class_id").empty();
            }
        });

        // when education type dropdown changes
        $('#education_type_id').on('change', function() {
            var educationTypeId = $(this).val();
            function processInput(educationTypeId) {
                var output = [];
                var json = educationTypeId.split(' '); // Split text by spaces into array

                json.forEach(function (item) { // Loop through each array item
                    var out = item.replace(/\'/g,''); // Remove all single quote '  from chunk
                    out = out.split(/(\d+)/); // Now again split the chunk by Digits into array
                    out = out.filter(Boolean); // With Boolean we can filter out False Boolean Values like -> false, null, 0
                    output.push(out);
                });

                return output;
            }

            var outputId = processInput(educationTypeId[0]);
            var outputType = processInput(educationTypeId[1]);

            if (outputType == "G") {
                var div_data = "";
                    $.ajax({
                        type: "GET",
                        url: "{{ route('class.get') }}?education_type_id=" + outputId,
                        success: function(data) {
                            if (data) {
                                $('#classInput').css('display', 'block');
                                $('#subEducationTypeInput').css('display', 'none');
                                $('#specialtyInput').css('display', 'none');
                                $('#specialtyClassInput').css('display', 'none');
                                $('#levelInput').css('display', 'none');
                                $('#levelClassInput').css('display', 'none');

                                $("#class_id").empty();
                                $("#class_id").append('<option value="">{{__("messages.select")}}</option>');
                                $.each(data, function(key, value) {
                                    $("#class_id").append('<option value="' + value.id + '">' + value.designation + '</option>');
                                });

                                // console.log(data);
                                    $.each(data, function (i, obj)
                                    {
                                        var check = "";
                                        // if (jQuery.inArray(obj.id, post_section_array) !== -1) {
                                        //     check = "checked";
                                        // }
                                        div_data += "<div class='form-check'>";
                                        div_data += "<label>";
                                        div_data += "<input type='checkbox' class='form-check-input' id='class_id' name='classIds[]' value='" + obj.id + "' " + check + ">" + obj.designation;
                                        div_data += "</label>";
                                        div_data += "</div>";
                                    });
                                    $('.class_checkbox').html(div_data);

                            } else {
                                $("#class_id").empty();
                            }
                        }
                    });
                } else {
                    $("#class_id").empty();
                }

            if (outputType == "T") {
                $.ajax({
                    type: "GET",
                    url: "{{ route('sub-education-type.get') }}?education_type_id=" + outputId,
                    success: function(res) {
                        if (res) {
                            $('#classInput').css('display', 'none');
                            $('#levelInput').css('display', 'none');
                            $('#levelClassInput').css('display', 'none');
                            $('#subEducationTypeInput').css('display', 'block');
                            $('#specialtyInput').css('display', 'block');
                            $('#specialtyClassInput').css('display', 'block');

                            $("#sub_education_type_id").empty();
                            $("#sub_education_type_id").append('<option value="">{{__("messages.select")}}</option>');
                            $.each(res, function(key, value) {
                                $("#sub_education_type_id").append('<option value="' + value.id + '">' + value.designation + '</option>');
                            });
                        } else {
                            $("#sub_education_type_id").empty();
                        }
                    }
                });
            } else {
                $("#sub_education_type_id").empty();
                $("#specialty_id").empty();
            }

            if (outputType == "E") {
                $.ajax({
                    type: "GET",
                    url: "{{ route('levels.get') }}?education_type_id=" + outputId,
                    success: function(res) {
                        if (res) {
                            $('#classInput').css('display', 'none');
                            $('#subEducationTypeInput').css('display', 'none');
                            $('#specialtyInput').css('display', 'none');
                            $('#specialtyClassInput').css('display', 'none');
                            $('#levelInput').css('display', 'block');
                            $('#levelClassInput').css('display', 'block');
                            $("#level_id").empty();
                            $("#level_id").append('<option value="">{{__("messages.select")}}</option>');
                            $.each(res, function(key, value) {
                                $("#level_id").append('<option value="' + value.id + '">' + value.designation + '</option>');
                            });
                        } else {
                            $("#level_id").empty();
                        }
                    }
                });
            } else {
                $("#level_id").empty();
                $("#level_class_id").empty();
            }
        });

        // when sub education type dropdown changes
        $('#sub_education_type_id').on('change', function() {
            var subEducationTypeId = $(this).val();
            if (subEducationTypeId) {
                $.ajax({
                    type: "GET",
                    url: "{{ route('specialty.get') }}?sub_education_type_id=" + subEducationTypeId,
                    success: function(res) {
                        if (res) {
                            $("#specialty_id").empty();
                            $("#specialty_id").append('<option value="">{{__("messages.select")}}</option>');
                            $.each(res, function(key, value) {
                                $("#specialty_id").append('<option value="' + value.id + '">' + value.designation + '</option>');
                            });
                        } else {
                            $("#specialty_id").empty();
                        }
                    }
                });
            } else {
                $("#specialty_id").empty();
            }
        });

        $('#specialty_id').on('change', function() {
            var specialtyId = $(this).val();
            if (specialtyId) {
                $.ajax({
                    type: "GET",
                    url: "{{ route('class.get-specialty-classes') }}?specialty_id=" + specialtyId,
                    success: function(data) {
                        var div_data = "";
                        if (data) {
                                $("#specialty_class_id").empty();
                                $("#specialty_class_id").append('<option value="">{{__("messages.select")}}</option>');
                                $.each(data, function(key, value) {
                                    $("#specialty_class_id").append('<option value="' + value.id + '">' + value.designation + '</option>');
                                });

                                $.each(data, function (i, obj)
                                {
                                    var check = "";
                                    // if (jQuery.inArray(obj.id, post_section_array) !== -1) {
                                    //     check = "checked";
                                    // }
                                    div_data += "<div class='form-check'>";
                                    div_data += "<label>";
                                    div_data += "<input type='checkbox' class='form-check-input' id='specialty_class_id' name='specialtyClassIds[]' value='" + obj.id + "' " + check + ">" + obj.designation;
                                    div_data += "</label>";
                                    div_data += "</div>";
                                });
                                $('.specialtyClass_checkbox').html(div_data);

                        } else {
                            $("#specialty_class_id").empty();
                        }
                    }
                });
            } else {
                $("#specialty_class_id").empty();
            }
        });

        $('#level_id').on('change', function() {
            var levelId = $(this).val();
            if (levelId) {
                var div_data = "";
                $.ajax({
                    type: "GET",
                    url: "{{ route('level-classes.get') }}?level_id=" + levelId,
                    success: function(data) {
                        if (data) {
                            $("#level_class_id").empty();
                            $("#level_class_id").append('<option value="">{{__("messages.select")}}</option>');
                            $.each(data, function(key, value) {
                                $("#level_class_id").append('<option value="' + value.id + '">' + value.designation + '</option>');
                            });

                            $.each(data, function (i, obj)
                            {
                                var check = "";
                                // if (jQuery.inArray(obj.id, post_section_array) !== -1) {
                                //     check = "checked";
                                // }
                                div_data += "<div class='form-check'>";
                                div_data += "<label>";
                                div_data += "<input type='checkbox' class='form-check-input' id='level_class_id' name='leveClassIds[]' value='" + obj.id + "' " + check + ">" + obj.designation;
                                div_data += "</label>";
                                div_data += "</div>";
                            });
                            $('.levelClass_checkbox').html(div_data);
                        } else {
                            $("#level_class_id").empty();
                        }
                    }
                });
            } else {
                $("#level_class_id").empty();
            }
        });
    </script>
	@yield("script")
</body>
</html>
